/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.typeutils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.scala.typeutils.TrySerializer;
import org.apache.flink.testutils.migration.MigrationVersion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.util.Failure;
import scala.util.Try;

@RunWith(value=Parameterized.class)
public class ScalaTrySerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Try<String>, Try<String>> {
    private static final String SPEC_NAME = "scala-try-serializer";

    public ScalaTrySerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<Try<String>, Try<String>> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (MigrationVersion migrationVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, migrationVersion, ScalaTrySerializerSetup.class, ScalaTrySerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class SpecifiedException
    extends RuntimeException {
        public SpecifiedException(String message) {
            super(message);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SpecifiedException)) {
                return false;
            }
            SpecifiedException other = (SpecifiedException)obj;
            return Objects.equals(this.getMessage(), other.getMessage());
        }
    }

    public static final class ScalaTrySerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Try<String>> {
        public TypeSerializer<Try<String>> createUpgradedSerializer() {
            return new TrySerializer((TypeSerializer)StringSerializer.INSTANCE, new ExecutionConfig());
        }

        public Matcher<Try<String>> testDataMatcher() {
            return Matchers.is((Object)new Failure((Throwable)new SpecifiedException("Specified exception for ScalaTry.")));
        }

        public Matcher<TypeSerializerSchemaCompatibility<Try<String>>> schemaCompatibilityMatcher(MigrationVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class ScalaTrySerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Try<String>> {
        public TypeSerializer<Try<String>> createPriorSerializer() {
            return new TrySerializer((TypeSerializer)StringSerializer.INSTANCE, new ExecutionConfig());
        }

        public Try<String> createTestData() {
            return new Failure((Throwable)new SpecifiedException("Specified exception for ScalaTry."));
        }
    }
}

