/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.typeutils;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.scala.typeutils.EitherSerializer;
import org.apache.flink.testutils.migration.MigrationVersion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.util.Either;
import scala.util.Right;

@RunWith(value=Parameterized.class)
public class ScalaEitherSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Either<Integer, String>, Either<Integer, String>> {
    private static final String SPEC_NAME = "scala-either-serializer";

    public ScalaEitherSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<Either<Integer, String>, Either<Integer, String>> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (MigrationVersion migrationVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, migrationVersion, EitherSerializerSetup.class, EitherSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class EitherSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Either<Integer, String>> {
        public TypeSerializer<Either<Integer, String>> createUpgradedSerializer() {
            return new EitherSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        }

        public Matcher<Either<Integer, String>> testDataMatcher() {
            return Matchers.is((Object)new Right((Object)"Hello world"));
        }

        public Matcher<TypeSerializerSchemaCompatibility<Either<Integer, String>>> schemaCompatibilityMatcher(MigrationVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class EitherSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Either<Integer, String>> {
        public TypeSerializer<Either<Integer, String>> createPriorSerializer() {
            return new EitherSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        }

        public Either<Integer, String> createTestData() {
            return new Right((Object)"Hello world");
        }
    }
}

