/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.scala.FlinkILoop;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.RemoteStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaShellRemoteStreamEnvironment
extends RemoteStreamEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(ScalaShellRemoteStreamEnvironment.class);
    private FlinkILoop flinkILoop;

    public ScalaShellRemoteStreamEnvironment(String host, int port, FlinkILoop flinkILoop, Configuration configuration, String ... jarFiles) {
        super(host, port, configuration, jarFiles);
        this.flinkILoop = flinkILoop;
    }

    protected JobExecutionResult executeRemotely(StreamGraph streamGraph, List<URL> jarFiles) throws ProgramInvocationException {
        URL jarUrl;
        try {
            jarUrl = this.flinkILoop.writeFilesToDisk().getAbsoluteFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ProgramInvocationException("Could not write the user code classes to disk.", (Throwable)e);
        }
        ArrayList<URL> allJarFiles = new ArrayList<URL>(jarFiles.size() + 1);
        allJarFiles.addAll(jarFiles);
        allJarFiles.add(jarUrl);
        return super.executeRemotely(streamGraph, allJarFiles);
    }

    public void setAsContext() {
        StreamExecutionEnvironmentFactory factory = new StreamExecutionEnvironmentFactory(){

            public StreamExecutionEnvironment createExecutionEnvironment() {
                throw new UnsupportedOperationException("Execution Environment is already defined for this shell.");
            }
        };
        ScalaShellRemoteStreamEnvironment.initializeContextEnvironment((StreamExecutionEnvironmentFactory)factory);
    }

    public static void disableAllContextAndOtherEnvironments() {
        StreamExecutionEnvironmentFactory factory = new StreamExecutionEnvironmentFactory(){

            public StreamExecutionEnvironment createExecutionEnvironment() {
                throw new UnsupportedOperationException("Execution Environment is already defined for this shell.");
            }
        };
        ScalaShellRemoteStreamEnvironment.initializeContextEnvironment((StreamExecutionEnvironmentFactory)factory);
    }

    public static void resetContextEnvironments() {
        StreamExecutionEnvironment.resetContextEnvironment();
    }
}

