/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.scala.ml;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.examples.java.ml.util.LinearRegressionData;
import org.apache.flink.examples.scala.ml.LinearRegression;
import org.apache.flink.examples.scala.ml.LinearRegression$;
import org.apache.flink.examples.scala.ml.LinearRegression$$anonfun$1$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class LinearRegression$ {
    public static final LinearRegression$ MODULE$;
    private boolean fileOutput;
    private String dataPath;
    private String outputPath;
    private int numIterations;

    static {
        new LinearRegression$();
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            DataSet<LinearRegression.Data> data = this.getDataSet(env);
            DataSet<LinearRegression.Params> parameters = this.getParamsDataSet(env);
            DataSet result = parameters.iterate(this.numIterations(), (Function1)new Serializable(data){
                public static final long serialVersionUID = 0L;
                private final DataSet data$1;

                /*
                 * WARNING - void declaration
                 */
                public final DataSet<LinearRegression.Params> apply(DataSet<LinearRegression.Params> currentParameters) {
                    void var2_2;
                    DataSet newParameters = this.data$1.map((MapFunction)new LinearRegression.SubUpdate(), (TypeInformation)new CaseClassTypeInfo<Tuple2<LinearRegression.Params, Object>>(this){

                        public /* synthetic */ TypeInformation[] protected$types(anonfun$1$$anon$9 x$1) {
                            return x$1.types;
                        }

                        public TypeSerializer<Tuple2<LinearRegression.Params, Object>> createSerializer(ExecutionConfig executionConfig) {
                            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$1$$anon$9 $outer;
                                private final ExecutionConfig executionConfig$1;
                                private final TypeSerializer[] fieldSerializers$3;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.executionConfig$1 = executionConfig$1;
                                    this.fieldSerializers$3 = fieldSerializers$3;
                                }
                            });
                            return new CaseClassSerializer<Tuple2<LinearRegression.Params, Object>>(this, fieldSerializers){

                                public Tuple2<LinearRegression.Params, Object> createInstance(Object[] fields) {
                                    return new Tuple2((Object)((LinearRegression.Params)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                                }
                            };
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class)).withBroadcastSet(currentParameters, "parameters").reduce((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<LinearRegression.Params, Object> apply(Tuple2<LinearRegression.Params, Object> p1, Tuple2<LinearRegression.Params, Object> p2) {
                            LinearRegression.Params result = ((LinearRegression.Params)p1._1()).$plus((LinearRegression.Params)p2._1());
                            return new Tuple2((Object)result, (Object)BoxesRunTime.boxToInteger((int)(p1._2$mcI$sp() + p2._2$mcI$sp())));
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final LinearRegression.Params apply(Tuple2<LinearRegression.Params, Object> x) {
                            return ((LinearRegression.Params)x._1()).div(x._2$mcI$sp());
                        }
                    }, (TypeInformation)new CaseClassTypeInfo<LinearRegression.Params>(this){

                        public /* synthetic */ TypeInformation[] protected$types(anonfun$1$$anon$12 x$1) {
                            return x$1.types;
                        }

                        public TypeSerializer<LinearRegression.Params> createSerializer(ExecutionConfig executionConfig) {
                            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$1$$anon$12 $outer;
                                private final ExecutionConfig executionConfig$4;
                                private final TypeSerializer[] fieldSerializers$4;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.executionConfig$4 = executionConfig$4;
                                    this.fieldSerializers$4 = fieldSerializers$4;
                                }
                            });
                            return new CaseClassSerializer<LinearRegression.Params>(this, fieldSerializers){

                                public LinearRegression.Params createInstance(Object[] fields) {
                                    return new LinearRegression.Params(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                                }
                            };
                        }
                    }, ClassTag$.MODULE$.apply(LinearRegression.Params.class));
                    return var2_2;
                }
                {
                    this.data$1 = data$1;
                }
            });
            if (this.fileOutput()) {
                result.writeAsText(this.outputPath(), result.writeAsText$default$2());
                env.execute("Scala Linear Regression example");
            } else {
                result.print();
            }
            return;
        }
    }

    private boolean fileOutput() {
        return this.fileOutput;
    }

    private void fileOutput_$eq(boolean x$1) {
        this.fileOutput = x$1;
    }

    private String dataPath() {
        return this.dataPath;
    }

    private void dataPath_$eq(String x$1) {
        this.dataPath = x$1;
    }

    private String outputPath() {
        return this.outputPath;
    }

    private void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private boolean parseParameters(String[] programArguments) {
        boolean bl;
        if (programArguments.length > 0) {
            this.fileOutput_$eq(true);
            if (programArguments.length == 3) {
                this.dataPath_$eq(programArguments[0]);
                this.outputPath_$eq(programArguments[1]);
                this.numIterations_$eq(new StringOps(Predef$.MODULE$.augmentString(programArguments[2])).toInt());
                bl = true;
            } else {
                System.err.println("Usage: LinearRegression <data path> <result path> <num iterations>");
                bl = false;
            }
        } else {
            System.out.println("Executing Linear Regression example with default parameters and built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("  We provide a data generator to create synthetic input files for this program.");
            System.out.println("  Usage: LinearRegression <data path> <result path> <num iterations>");
            bl = true;
        }
        return bl;
    }

    private DataSet<LinearRegression.Data> getDataSet(ExecutionEnvironment env) {
        DataSet dataSet;
        if (this.fileOutput()) {
            String x$1 = this.dataPath();
            String x$2 = " ";
            int[] x$3 = new int[]{0, 1};
            String x$4 = env.readCsvFile$default$2();
            Character x$5 = env.readCsvFile$default$4();
            boolean x$6 = env.readCsvFile$default$5();
            String x$7 = env.readCsvFile$default$6();
            boolean x$8 = env.readCsvFile$default$7();
            String[] x$9 = env.readCsvFile$default$9();
            dataSet = env.readCsvFile(x$1, x$4, x$2, x$5, x$6, x$7, x$8, x$3, x$9, ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.13 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.13 $outer;
                        private final ExecutionConfig executionConfig$5;
                        private final TypeSerializer[] fieldSerializers$5;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$5 = executionConfig$5;
                            this.fieldSerializers$5 = fieldSerializers$5;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                        public Tuple2<Object, Object> createInstance(Object[] fields) {
                            return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final LinearRegression.Data apply(Tuple2<Object, Object> t) {
                    return new LinearRegression.Data(t._1$mcD$sp(), t._2$mcD$sp());
                }
            }, (TypeInformation)new CaseClassTypeInfo<LinearRegression.Data>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.14 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<LinearRegression.Data> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.14 $outer;
                        private final ExecutionConfig executionConfig$6;
                        private final TypeSerializer[] fieldSerializers$6;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$6 = executionConfig$6;
                            this.fieldSerializers$6 = fieldSerializers$6;
                        }
                    });
                    return new CaseClassSerializer<LinearRegression.Data>(this, fieldSerializers){

                        public LinearRegression.Data createInstance(Object[] fields) {
                            return new LinearRegression.Data(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(LinearRegression.Data.class));
        } else {
            LinearRegression.Data[] data = (LinearRegression.Data[])Predef$.MODULE$.refArrayOps((Object[])LinearRegressionData.DATA).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final LinearRegression.Data apply(Object[] x0$1) {
                    Object[] objectArray = x0$1;
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        Object x = ((SeqLike)option.get()).apply(0);
                        Object y = ((SeqLike)option.get()).apply(1);
                        LinearRegression.Data data = new LinearRegression.Data(BoxesRunTime.unboxToDouble((Object)x), BoxesRunTime.unboxToDouble((Object)y));
                        return data;
                    }
                    throw new MatchError((Object)objectArray);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LinearRegression.Data.class)));
            dataSet = env.fromCollection((Iterable)Predef$.MODULE$.wrapRefArray((Object[])data), ClassTag$.MODULE$.apply(LinearRegression.Data.class), (TypeInformation)new CaseClassTypeInfo<LinearRegression.Data>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.15 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<LinearRegression.Data> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.15 $outer;
                        private final ExecutionConfig executionConfig$7;
                        private final TypeSerializer[] fieldSerializers$7;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$7 = executionConfig$7;
                            this.fieldSerializers$7 = fieldSerializers$7;
                        }
                    });
                    return new CaseClassSerializer<LinearRegression.Data>(this, fieldSerializers){

                        public LinearRegression.Data createInstance(Object[] fields) {
                            return new LinearRegression.Data(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                        }
                    };
                }
            });
        }
        return dataSet;
    }

    private DataSet<LinearRegression.Params> getParamsDataSet(ExecutionEnvironment env) {
        LinearRegression.Params[] params = (LinearRegression.Params[])Predef$.MODULE$.refArrayOps((Object[])LinearRegressionData.PARAMS).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LinearRegression.Params apply(Object[] x0$2) {
                Object[] objectArray = x0$2;
                Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    Object x = ((SeqLike)option.get()).apply(0);
                    Object y = ((SeqLike)option.get()).apply(1);
                    LinearRegression.Params params = new LinearRegression.Params(BoxesRunTime.unboxToDouble((Object)x), BoxesRunTime.unboxToDouble((Object)y));
                    return params;
                }
                throw new MatchError((Object)objectArray);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LinearRegression.Params.class)));
        return env.fromCollection((Iterable)Predef$.MODULE$.wrapRefArray((Object[])params), ClassTag$.MODULE$.apply(LinearRegression.Params.class), (TypeInformation)new CaseClassTypeInfo<LinearRegression.Params>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<LinearRegression.Params> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.16 $outer;
                    private final ExecutionConfig executionConfig$8;
                    private final TypeSerializer[] fieldSerializers$8;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$8 = executionConfig$8;
                        this.fieldSerializers$8 = fieldSerializers$8;
                    }
                });
                return new CaseClassSerializer<LinearRegression.Params>(this, fieldSerializers){

                    public LinearRegression.Params createInstance(Object[] fields) {
                        return new LinearRegression.Params(BoxesRunTime.unboxToDouble((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                    }
                };
            }
        });
    }

    private LinearRegression$() {
        MODULE$ = this;
        this.fileOutput = false;
        this.dataPath = null;
        this.outputPath = null;
        this.numIterations = 10;
    }
}

