/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.scala.clustering;

import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.examples.scala.clustering.KMeans$;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Traversable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\ter!B\u0001\u0003\u0011\u0003y\u0011AB&NK\u0006t7O\u0003\u0002\u0004\t\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u00151\u0011!B:dC2\f'BA\u0004\t\u0003!)\u00070Y7qY\u0016\u001c(BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001A\u0011\u0001#E\u0007\u0002\u0005\u0019)!C\u0001E\u0001'\t11*T3b]N\u001c\"!\u0005\u000b\u0011\u0005U9R\"\u0001\f\u000b\u0003\u0015I!\u0001\u0007\f\u0003\r\u0005s\u0017PU3g\u0011\u0015Q\u0012\u0003\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\tq\u0002C\u0003\u001e#\u0011\u0005a$\u0001\u0003nC&tGCA\u0010#!\t)\u0002%\u0003\u0002\"-\t!QK\\5u\u0011\u0015\u0019C\u00041\u0001%\u0003\u0011\t'oZ:\u0011\u0007U)s%\u0003\u0002'-\t)\u0011I\u001d:bsB\u0011\u0001f\u000b\b\u0003+%J!A\u000b\f\u0002\rA\u0013X\rZ3g\u0013\taSF\u0001\u0004TiJLgn\u001a\u0006\u0003UYAQaL\t\u0005\nA\nq\u0002]1sg\u0016\u0004\u0016M]1nKR,'o\u001d\u000b\u0003cQ\u0002\"!\u0006\u001a\n\u0005M2\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006k9\u0002\r\u0001J\u0001\u0011aJ|wM]1n\u0003J<W/\\3oiNDQaN\t\u0005\na\nqbZ3u!>Lg\u000e\u001e#bi\u0006\u001cV\r\u001e\u000b\u0003se\u00042A\u000f A\u001b\u0005Y$BA\u0003=\u0015\ti\u0004\"A\u0002ba&L!aP\u001e\u0003\u000f\u0011\u000bG/Y*fiB\u0011\u0011IQ\u0007\u0002#\u0019!1)\u0005\u0001E\u0005\u0015\u0001v.\u001b8u'\r\u0011E#\u0012\t\u0003+\u0019K!a\u0012\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011%\u0013%\u00111A\u0005\u0002)\u000b\u0011\u0001_\u000b\u0002\u0017B\u0011Q\u0003T\u0005\u0003\u001bZ\u0011a\u0001R8vE2,\u0007\u0002C(C\u0005\u0003\u0007I\u0011\u0001)\u0002\u000ba|F%Z9\u0015\u0005}\t\u0006b\u0002*O\u0003\u0003\u0005\raS\u0001\u0004q\u0012\n\u0004\u0002\u0003+C\u0005\u0003\u0005\u000b\u0015B&\u0002\u0005a\u0004\u0003\u0002\u0003,C\u0005\u0003\u0007I\u0011\u0001&\u0002\u0003eD\u0001\u0002\u0017\"\u0003\u0002\u0004%\t!W\u0001\u0006s~#S-\u001d\u000b\u0003?iCqAU,\u0002\u0002\u0003\u00071\n\u0003\u0005]\u0005\n\u0005\t\u0015)\u0003L\u0003\tI\b\u0005C\u0003\u001b\u0005\u0012\u0005a\fF\u0002A?\u0002DQ!S/A\u0002-CQAV/A\u0002-CQA\u0007\"\u0005\u0002\t$\u0012\u0001\u0011\u0005\u0006I\n#\t!Z\u0001\u0004C\u0012$GC\u0001!g\u0011\u001597\r1\u0001A\u0003\u0015yG\u000f[3s\u0011\u0015I'\t\"\u0001k\u0003\r!\u0017N\u001e\u000b\u0003\u0001.DQa\u001a5A\u00021\u0004\"!F7\n\u000594\"\u0001\u0002'p]\u001eDQ\u0001\u001d\"\u0005\u0002E\f\u0011#Z;dY&$W-\u00198ESN$\u0018M\\2f)\tY%\u000fC\u0003h_\u0002\u0007\u0001\tC\u0003u\u0005\u0012\u0005Q/A\u0003dY\u0016\f'\u000fF\u0001 \u0011\u00159(\t\"\u0011y\u0003!!xn\u0015;sS:<G#A\u0014\t\u000bi4\u0004\u0019A>\u0002\u0007\u0015tg\u000f\u0005\u0002;y&\u0011Qp\u000f\u0002\u0015\u000bb,7-\u001e;j_:,eN^5s_:lWM\u001c;\t\r}\fB\u0011BA\u0001\u0003I9W\r^\"f]R\u0014x.\u001b3ECR\f7+\u001a;\u0015\t\u0005\r\u00111\t\t\u0005uy\n)\u0001E\u0002B\u0003\u000f1a!!\u0003\u0012\u0001\u0005-!\u0001C\"f]R\u0014x.\u001b3\u0014\u0007\u0005\u001d\u0001\tC\u0006\u0002\u0010\u0005\u001d!\u00111A\u0005\u0002\u0005E\u0011AA5e+\t\t\u0019\u0002E\u0002\u0016\u0003+I1!a\u0006\u0017\u0005\rIe\u000e\u001e\u0005\f\u00037\t9A!a\u0001\n\u0003\ti\"\u0001\u0004jI~#S-\u001d\u000b\u0004?\u0005}\u0001\"\u0003*\u0002\u001a\u0005\u0005\t\u0019AA\n\u0011-\t\u0019#a\u0002\u0003\u0002\u0003\u0006K!a\u0005\u0002\u0007%$\u0007\u0005C\u0005J\u0003\u000f\u0011\t\u0011)A\u0005\u0017\"Ia+a\u0002\u0003\u0002\u0003\u0006Ia\u0013\u0005\b5\u0005\u001dA\u0011AA\u0016)!\t)!!\f\u00020\u0005E\u0002\u0002CA\b\u0003S\u0001\r!a\u0005\t\r%\u000bI\u00031\u0001L\u0011\u00191\u0016\u0011\u0006a\u0001\u0017\"9!$a\u0002\u0005\u0002\u0005UBCAA\u0003\u0011\u001dQ\u0012q\u0001C\u0001\u0003s!b!!\u0002\u0002<\u0005u\u0002\u0002CA\b\u0003o\u0001\r!a\u0005\t\u000f\u0005}\u0012q\u0007a\u0001\u0001\u0006\t\u0001\u000f\u0003\u0004x\u0003\u000f!\t\u0005\u001f\u0005\u0006uz\u0004\ra\u001f\u0005\n\u0003\u000f\n\u0002\u0019!C\u0005\u0003\u0013\n!BZ5mK>+H\u000f];u+\u0005\t\u0004\"CA'#\u0001\u0007I\u0011BA(\u000391\u0017\u000e\\3PkR\u0004X\u000f^0%KF$2aHA)\u0011!\u0011\u00161JA\u0001\u0002\u0004\t\u0004bBA+#\u0001\u0006K!M\u0001\fM&dWmT;uaV$\b\u0005C\u0005\u0002ZE\u0001\r\u0011\"\u0003\u0002\\\u0005Q\u0001o\\5oiN\u0004\u0016\r\u001e5\u0016\u0003\u001dB\u0011\"a\u0018\u0012\u0001\u0004%I!!\u0019\u0002\u001dA|\u0017N\u001c;t!\u0006$\bn\u0018\u0013fcR\u0019q$a\u0019\t\u0011I\u000bi&!AA\u0002\u001dBq!a\u001a\u0012A\u0003&q%A\u0006q_&tGo\u001d)bi\"\u0004\u0003\"CA6#\u0001\u0007I\u0011BA.\u0003-\u0019WM\u001c;feN\u0004\u0016\r\u001e5\t\u0013\u0005=\u0014\u00031A\u0005\n\u0005E\u0014aD2f]R,'o\u001d)bi\"|F%Z9\u0015\u0007}\t\u0019\b\u0003\u0005S\u0003[\n\t\u00111\u0001(\u0011\u001d\t9(\u0005Q!\n\u001d\nAbY3oi\u0016\u00148\u000fU1uQ\u0002B\u0011\"a\u001f\u0012\u0001\u0004%I!a\u0017\u0002\u0015=,H\u000f];u!\u0006$\b\u000eC\u0005\u0002\u0000E\u0001\r\u0011\"\u0003\u0002\u0002\u0006qq.\u001e;qkR\u0004\u0016\r\u001e5`I\u0015\fHcA\u0010\u0002\u0004\"A!+! \u0002\u0002\u0003\u0007q\u0005C\u0004\u0002\bF\u0001\u000b\u0015B\u0014\u0002\u0017=,H\u000f];u!\u0006$\b\u000e\t\u0005\n\u0003\u0017\u000b\u0002\u0019!C\u0005\u0003#\tQB\\;n\u0013R,'/\u0019;j_:\u001c\b\"CAH#\u0001\u0007I\u0011BAI\u0003EqW/\\%uKJ\fG/[8og~#S-\u001d\u000b\u0004?\u0005M\u0005\"\u0003*\u0002\u000e\u0006\u0005\t\u0019AA\n\u0011!\t9*\u0005Q!\n\u0005M\u0011A\u00048v[&#XM]1uS>t7\u000f\t\u0004\u0007\u00037\u000b\"!!(\u0003'M+G.Z2u\u001d\u0016\f'/Z:u\u0007\u0016tG/\u001a:\u0014\t\u0005e\u0015q\u0014\t\b\u0003C\u000bY\u000bQAX\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016!\u00034v]\u000e$\u0018n\u001c8t\u0015\r\tI\u000bP\u0001\u0007G>lWn\u001c8\n\t\u00055\u00161\u0015\u0002\u0010%&\u001c\u0007.T1q\rVt7\r^5p]B1Q#!-\u0002\u0014\u0001K1!a-\u0017\u0005\u0019!V\u000f\u001d7fe!9!$!'\u0005\u0002\u0005]FCAA]!\r\t\u0015\u0011\u0014\u0005\u000b\u0003{\u000bI\n1A\u0005\n\u0005}\u0016!C2f]R\u0014x.\u001b3t+\t\t\t\r\u0005\u0004\u0002D\u0006M\u0017Q\u0001\b\u0005\u0003\u000b\fyM\u0004\u0003\u0002H\u00065WBAAe\u0015\r\tYMD\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015I1!!5\u0017\u0003\u001d\u0001\u0018mY6bO\u0016LA!!6\u0002X\nYAK]1wKJ\u001c\u0018M\u00197f\u0015\r\t\tN\u0006\u0005\u000b\u00037\fI\n1A\u0005\n\u0005u\u0017!D2f]R\u0014x.\u001b3t?\u0012*\u0017\u000fF\u0002 \u0003?D\u0011BUAm\u0003\u0003\u0005\r!!1\t\u0013\u0005\r\u0018\u0011\u0014Q!\n\u0005\u0005\u0017AC2f]R\u0014x.\u001b3tA!A\u0011q]AM\t\u0003\nI/\u0001\u0003pa\u0016tGcA\u0010\u0002l\"A\u0011Q^As\u0001\u0004\ty/\u0001\u0006qCJ\fW.\u001a;feN\u0004B!!=\u0002x6\u0011\u00111\u001f\u0006\u0004\u0003kD\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002z\u0006M(!D\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0005\u0002~\u0006eE\u0011AA\u0000\u0003\ri\u0017\r\u001d\u000b\u0005\u0003_\u0013\t\u0001C\u0004\u0002@\u0005m\b\u0019\u0001!)\u0011\u0005e%Q\u0001B\u0019\u0005g\u0001BAa\u0002\u0003,9!!\u0011\u0002B\u0013\u001d\u0011\u0011YA!\t\u000f\t\t5!Q\u0004\b\u0005\u0005\u001f\u0011YB\u0004\u0003\u0003\u0012\tea\u0002\u0002B\n\u0005/qA!a2\u0003\u0016%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003{!I1Aa\b=\u0003\u0011Q\u0017M^1\n\t\u0005\u0015&1\u0005\u0006\u0004\u0005?a\u0014\u0002\u0002B\u0014\u0005S\t!CR;oGRLwN\\!o]>$\u0018\r^5p]*!\u0011Q\u0015B\u0012\u0013\u0011\u0011iCa\f\u0003\u001f\u0019{'o^1sI\u0016$g)[3mINTAAa\n\u0003*\u0005)a/\u00197vK2\u0012!QG\u0011\u0003\u0005o\tQAK\u0017??J\u0002")
public final class KMeans {
    public static void main(String[] stringArray) {
        KMeans$.MODULE$.main(stringArray);
    }

    public static class Point
    implements Serializable {
        private double x;
        private double y;

        public double x() {
            return this.x;
        }

        public void x_$eq(double x$1) {
            this.x = x$1;
        }

        public double y() {
            return this.y;
        }

        public void y_$eq(double x$1) {
            this.y = x$1;
        }

        public Point add(Point other) {
            this.x_$eq(this.x() + other.x());
            this.y_$eq(this.y() + other.y());
            return this;
        }

        public Point div(long other) {
            this.x_$eq(this.x() / (double)other);
            this.y_$eq(this.y() / (double)other);
            return this;
        }

        public double euclideanDistance(Point other) {
            return Math.sqrt((this.x() - other.x()) * (this.x() - other.x()) + (this.y() - other.y()) * (this.y() - other.y()));
        }

        public void clear() {
            this.x_$eq(0.0);
            this.y_$eq(0.0);
        }

        public String toString() {
            return new StringBuilder().append(this.x()).append((Object)" ").append((Object)BoxesRunTime.boxToDouble((double)this.y())).toString();
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public Point() {
            this(0.0, 0.0);
        }
    }

    public static class Centroid
    extends Point {
        private int id;

        public int id() {
            return this.id;
        }

        public void id_$eq(int x$1) {
            this.id = x$1;
        }

        @Override
        public String toString() {
            return new StringBuilder().append(this.id()).append((Object)" ").append((Object)super.toString()).toString();
        }

        public Centroid(int id, double x, double y) {
            this.id = id;
            super(x, y);
        }

        public Centroid() {
            this(0, 0.0, 0.0);
        }

        public Centroid(int id, Point p) {
            this(id, p.x(), p.y());
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->_2"})
    public static final class SelectNearestCenter
    extends RichMapFunction<Point, Tuple2<Object, Point>> {
        private Traversable<Centroid> centroids = null;

        private Traversable<Centroid> centroids() {
            return this.centroids;
        }

        private void centroids_$eq(Traversable<Centroid> x$1) {
            this.centroids = x$1;
        }

        public void open(Configuration parameters) {
            this.centroids_$eq((Traversable<Centroid>)((Traversable)JavaConverters$.MODULE$.asScalaBufferConverter(this.getRuntimeContext().getBroadcastVariable("centroids")).asScala()));
        }

        public Tuple2<Object, Point> map(Point p) {
            DoubleRef minDistance = DoubleRef.create((double)Double.MAX_VALUE);
            IntRef closestCentroidId = IntRef.create((int)-1);
            this.centroids().foreach((Function1)new Serializable(this, p, minDistance, closestCentroidId){
                public static final long serialVersionUID = 0L;
                private final Point p$1;
                private final DoubleRef minDistance$1;
                private final IntRef closestCentroidId$1;

                public final void apply(Centroid centroid) {
                    double distance = this.p$1.euclideanDistance(centroid);
                    if (distance < this.minDistance$1.elem) {
                        this.minDistance$1.elem = distance;
                        this.closestCentroidId$1.elem = centroid.id();
                    }
                }
                {
                    this.p$1 = p$1;
                    this.minDistance$1 = minDistance$1;
                    this.closestCentroidId$1 = closestCentroidId$1;
                }
            });
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)closestCentroidId.elem), (Object)p);
        }
    }
}

