/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.scala.wordcount;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.AggregateDataSet;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.examples.java.wordcount.util.WordCountData;
import org.apache.flink.examples.scala.wordcount.WordCount$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class WordCount$ {
    public static final WordCount$ MODULE$;
    private boolean fileOutput;
    private String textPath;
    private String outputPath;

    static {
        new WordCount$();
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            DataSet<String> text = this.getTextDataSet(env);
            AggregateDataSet counts = text.flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ArrayOps<String> apply(String x$1) {
                    return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])x$1.toLowerCase().split("\\W+")).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$2) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
                        }
                    }));
                }
            }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class), ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(String x$3) {
                    return new Tuple2((Object)x$3, (Object)BoxesRunTime.boxToInteger((int)1));
                }
            }, (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.2 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.2 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                        public Tuple2<String, Object> createInstance(Object[] fields) {
                            return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)).groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).sum(1);
            if (this.fileOutput()) {
                counts.writeAsCsv(this.outputPath(), "\n", " ", counts.writeAsCsv$default$4());
                env.execute("Scala WordCount Example");
            } else {
                counts.print();
            }
            return;
        }
    }

    private boolean parseParameters(String[] args) {
        boolean bl;
        if (args.length > 0) {
            this.fileOutput_$eq(true);
            if (args.length == 2) {
                this.textPath_$eq(args[0]);
                this.outputPath_$eq(args[1]);
                bl = true;
            } else {
                System.err.println("Usage: WordCount <text path> <result path>");
                bl = false;
            }
        } else {
            System.out.println("Executing WordCount example with built-in default data.");
            System.out.println("  Provide parameters to read input data from a file.");
            System.out.println("  Usage: WordCount <text path> <result path>");
            bl = true;
        }
        return bl;
    }

    private DataSet<String> getTextDataSet(ExecutionEnvironment env) {
        return this.fileOutput() ? env.readTextFile(this.textPath(), env.readTextFile$default$2()) : env.fromCollection((Iterable)Predef$.MODULE$.wrapRefArray((Object[])WordCountData.WORDS), ClassTag$.MODULE$.apply(String.class), (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
    }

    private boolean fileOutput() {
        return this.fileOutput;
    }

    private void fileOutput_$eq(boolean x$1) {
        this.fileOutput = x$1;
    }

    private String textPath() {
        return this.textPath;
    }

    private void textPath_$eq(String x$1) {
        this.textPath = x$1;
    }

    private String outputPath() {
        return this.outputPath;
    }

    private void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    private WordCount$() {
        MODULE$ = this;
        this.fileOutput = false;
        this.textPath = null;
        this.outputPath = null;
    }
}

