/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.scala.graph;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.JoinDataSet;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.examples.java.graph.util.EnumTrianglesData;
import org.apache.flink.examples.scala.graph.EnumTrianglesBasic;
import org.apache.flink.examples.scala.graph.EnumTrianglesBasic$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class EnumTrianglesBasic$ {
    public static final EnumTrianglesBasic$ MODULE$;
    private boolean fileOutput;
    private String edgePath;
    private String outputPath;

    static {
        new EnumTrianglesBasic$();
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            DataSet<EnumTrianglesBasic.Edge> edges = this.getEdgeDataSet(env);
            DataSet edgesById = edges.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final EnumTrianglesBasic.Edge apply(EnumTrianglesBasic.Edge e) {
                    return e.v1() < e.v2() ? e : new EnumTrianglesBasic.Edge(e.v2(), e.v1());
                }
            }, (TypeInformation)new CaseClassTypeInfo<EnumTrianglesBasic.Edge>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.6 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<EnumTrianglesBasic.Edge> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.6 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<EnumTrianglesBasic.Edge>(this, fieldSerializers){

                        public EnumTrianglesBasic.Edge createInstance(Object[] fields) {
                            return new EnumTrianglesBasic.Edge(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(EnumTrianglesBasic.Edge.class));
            DataSet triangles = ((JoinDataSet)edgesById.groupBy("v1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sortGroup("v2", Order.ASCENDING).reduceGroup((GroupReduceFunction)new EnumTrianglesBasic.TriadBuilder(), (TypeInformation)new CaseClassTypeInfo<EnumTrianglesBasic.Triad>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.7 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<EnumTrianglesBasic.Triad> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.7 $outer;
                        private final ExecutionConfig executionConfig$2;
                        private final TypeSerializer[] fieldSerializers$2;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$2 = executionConfig$2;
                            this.fieldSerializers$2 = fieldSerializers$2;
                        }
                    });
                    return new CaseClassSerializer<EnumTrianglesBasic.Triad>(this, fieldSerializers){

                        public EnumTrianglesBasic.Triad createInstance(Object[] fields) {
                            return new EnumTrianglesBasic.Triad(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToInt((Object)fields[2]));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(EnumTrianglesBasic.Triad.class)).join(edgesById).where("v2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v3"})).equalTo("v1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v2"}))).apply((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final EnumTrianglesBasic.Triad apply(EnumTrianglesBasic.Triad t, EnumTrianglesBasic.Edge x$1) {
                    return t;
                }
            }, (TypeInformation)new CaseClassTypeInfo<EnumTrianglesBasic.Triad>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.8 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<EnumTrianglesBasic.Triad> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.8 $outer;
                        private final ExecutionConfig executionConfig$3;
                        private final TypeSerializer[] fieldSerializers$3;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$3 = executionConfig$3;
                            this.fieldSerializers$3 = fieldSerializers$3;
                        }
                    });
                    return new CaseClassSerializer<EnumTrianglesBasic.Triad>(this, fieldSerializers){

                        public EnumTrianglesBasic.Triad createInstance(Object[] fields) {
                            return new EnumTrianglesBasic.Triad(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToInt((Object)fields[2]));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(EnumTrianglesBasic.Triad.class)).withForwardedFieldsFirst((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*"}));
            if (this.fileOutput()) {
                triangles.writeAsCsv(this.outputPath(), "\n", ",", triangles.writeAsCsv$default$4());
                env.execute("TriangleEnumeration Example");
            } else {
                triangles.print();
            }
            return;
        }
    }

    private boolean parseParameters(String[] args) {
        boolean bl;
        if (args.length > 0) {
            this.fileOutput_$eq(true);
            if (args.length == 2) {
                this.edgePath_$eq(args[0]);
                this.outputPath_$eq(args[1]);
                bl = true;
            } else {
                System.err.println("Usage: EnumTriangleBasic <edge path> <result path>");
                bl = false;
            }
        } else {
            System.out.println("Executing Enum Triangles Basic example with built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("  Usage: EnumTriangleBasic <edge path> <result path>");
            bl = true;
        }
        return bl;
    }

    private DataSet<EnumTrianglesBasic.Edge> getEdgeDataSet(ExecutionEnvironment env) {
        DataSet dataSet;
        if (this.fileOutput()) {
            String x$2 = this.edgePath();
            String x$3 = " ";
            int[] x$4 = new int[]{0, 1};
            String x$5 = env.readCsvFile$default$2();
            Character x$6 = env.readCsvFile$default$4();
            boolean x$7 = env.readCsvFile$default$5();
            String x$8 = env.readCsvFile$default$6();
            boolean x$9 = env.readCsvFile$default$7();
            String[] x$10 = env.readCsvFile$default$9();
            dataSet = env.readCsvFile(x$2, x$5, x$3, x$6, x$7, x$8, x$9, x$4, x$10, ClassTag$.MODULE$.apply(EnumTrianglesBasic.Edge.class), (TypeInformation)new CaseClassTypeInfo<EnumTrianglesBasic.Edge>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.9 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<EnumTrianglesBasic.Edge> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.9 $outer;
                        private final ExecutionConfig executionConfig$4;
                        private final TypeSerializer[] fieldSerializers$4;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$4 = executionConfig$4;
                            this.fieldSerializers$4 = fieldSerializers$4;
                        }
                    });
                    return new CaseClassSerializer<EnumTrianglesBasic.Edge>(this, fieldSerializers){

                        public EnumTrianglesBasic.Edge createInstance(Object[] fields) {
                            return new EnumTrianglesBasic.Edge(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                        }
                    };
                }
            });
        } else {
            EnumTrianglesBasic.Edge[] edges = (EnumTrianglesBasic.Edge[])Predef$.MODULE$.refArrayOps((Object[])EnumTrianglesData.EDGES).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final EnumTrianglesBasic.Edge apply(Object[] x0$1) {
                    Object[] objectArray = x0$1;
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        Object v1 = ((SeqLike)option.get()).apply(0);
                        Object v2 = ((SeqLike)option.get()).apply(1);
                        EnumTrianglesBasic.Edge edge = new EnumTrianglesBasic.Edge(BoxesRunTime.unboxToInt((Object)v1), BoxesRunTime.unboxToInt((Object)v2));
                        return edge;
                    }
                    throw new MatchError((Object)objectArray);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(EnumTrianglesBasic.Edge.class)));
            dataSet = env.fromCollection((Iterable)Predef$.MODULE$.wrapRefArray((Object[])edges), ClassTag$.MODULE$.apply(EnumTrianglesBasic.Edge.class), (TypeInformation)new CaseClassTypeInfo<EnumTrianglesBasic.Edge>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.10 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<EnumTrianglesBasic.Edge> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.10 $outer;
                        private final ExecutionConfig executionConfig$5;
                        private final TypeSerializer[] fieldSerializers$5;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$5 = executionConfig$5;
                            this.fieldSerializers$5 = fieldSerializers$5;
                        }
                    });
                    return new CaseClassSerializer<EnumTrianglesBasic.Edge>(this, fieldSerializers){

                        public EnumTrianglesBasic.Edge createInstance(Object[] fields) {
                            return new EnumTrianglesBasic.Edge(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                        }
                    };
                }
            });
        }
        return dataSet;
    }

    private boolean fileOutput() {
        return this.fileOutput;
    }

    private void fileOutput_$eq(boolean x$1) {
        this.fileOutput = x$1;
    }

    private String edgePath() {
        return this.edgePath;
    }

    private void edgePath_$eq(String x$1) {
        this.edgePath = x$1;
    }

    private String outputPath() {
        return this.outputPath;
    }

    private void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    private EnumTrianglesBasic$() {
        MODULE$ = this;
        this.fileOutput = false;
        this.edgePath = null;
        this.outputPath = null;
    }
}

