/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.scala.relational;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.CoGroupDataSet;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.JoinDataSet;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.examples.java.relational.util.WebLogData;
import org.apache.flink.examples.scala.relational.WebLogAnalysis$;
import org.apache.flink.util.Collector;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class WebLogAnalysis$ {
    public static final WebLogAnalysis$ MODULE$;
    private boolean fileOutput;
    private String documentsPath;
    private String ranksPath;
    private String visitsPath;
    private String outputPath;

    static {
        new WebLogAnalysis$();
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            DataSet<Tuple2<String, String>> documents = this.getDocumentsDataSet(env);
            DataSet<Tuple3<Object, String, Object>> ranks = this.getRanksDataSet(env);
            DataSet<Tuple2<String, String>> visits = this.getVisitsDataSet(env);
            DataSet filteredDocs = documents.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> doc) {
                    return ((String)doc._2()).contains(" editors ") && ((String)doc._2()).contains(" oscillations ");
                }
            });
            DataSet filteredRanks = ranks.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple3<Object, String, Object> rank) {
                    return BoxesRunTime.unboxToInt((Object)rank._1()) > 40;
                }
            });
            DataSet filteredVisits = visits.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> visit) {
                    return new StringOps(Predef$.MODULE$.augmentString(((String)visit._2()).substring(0, 4))).toInt() == 2007;
                }
            });
            DataSet joinDocsRanks = ((JoinDataSet)filteredDocs.join(filteredRanks).where((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).equalTo((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))).apply((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple3<Object, String, Object> apply(Tuple2<String, String> doc, Tuple3<Object, String, Object> rank) {
                    return rank;
                }
            }, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(){

                public TypeInformation<?>[] protected$types(anon.9 x$1) {
                    return x$1.types;
                }

                public Class<Tuple3<Object, String, Object>> protected$tupleType(anon.9 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.9 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(Tuple3.class)).withForwardedFieldsSecond((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*"}));
            DataSet result = ((CoGroupDataSet)joinDocsRanks.coGroup(filteredVisits, ClassTag$.MODULE$.apply(Tuple2.class)).where((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).equalTo((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))).apply((Function3)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterator<Tuple3<Object, String, Object>> ranks, Iterator<Tuple2<String, String>> visits, Collector<Tuple3<Object, String, Object>> out) {
                    if (visits.isEmpty()) {
                        ranks.foreach((Function1)new Serializable(this, out){
                            public static final long serialVersionUID = 0L;
                            private final Collector out$1;

                            public final void apply(Tuple3<Object, String, Object> rank) {
                                this.out$1.collect(rank);
                            }
                            {
                                this.out$1 = out$1;
                            }
                        });
                    }
                }
            }, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(){

                public TypeInformation<?>[] protected$types(anon.10 x$1) {
                    return x$1.types;
                }

                public Class<Tuple3<Object, String, Object>> protected$tupleType(anon.10 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.10 $outer;
                        private final ExecutionConfig executionConfig$2;
                        private final TypeSerializer[] fieldSerializers$2;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$2 = executionConfig$2;
                            this.fieldSerializers$2 = fieldSerializers$2;
                        }
                    });
                    return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(Tuple3.class)).withForwardedFieldsFirst((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*"}));
            if (this.fileOutput()) {
                result.writeAsCsv(this.outputPath(), "\n", "|", result.writeAsCsv$default$4());
                env.execute("Scala WebLogAnalysis Example");
            } else {
                result.print();
            }
            return;
        }
    }

    private boolean fileOutput() {
        return this.fileOutput;
    }

    private void fileOutput_$eq(boolean x$1) {
        this.fileOutput = x$1;
    }

    private String documentsPath() {
        return this.documentsPath;
    }

    private void documentsPath_$eq(String x$1) {
        this.documentsPath = x$1;
    }

    private String ranksPath() {
        return this.ranksPath;
    }

    private void ranksPath_$eq(String x$1) {
        this.ranksPath = x$1;
    }

    private String visitsPath() {
        return this.visitsPath;
    }

    private void visitsPath_$eq(String x$1) {
        this.visitsPath = x$1;
    }

    private String outputPath() {
        return this.outputPath;
    }

    private void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing WebLog Analysis example with built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("  We provide a data generator to create synthetic input files for this program.");
            System.out.println("  Usage: WebLogAnalysis <documents path> <ranks path> <visits path> <result path>");
            return true;
        }
        this.fileOutput_$eq(true);
        if (args.length == 4) {
            this.documentsPath_$eq(args[0]);
            this.ranksPath_$eq(args[1]);
            this.visitsPath_$eq(args[2]);
            this.outputPath_$eq(args[3]);
            return true;
        }
        System.err.println("Usage: WebLogAnalysis <documents path> <ranks path> <visits path> <result path>");
        return false;
    }

    private DataSet<Tuple2<String, String>> getDocumentsDataSet(ExecutionEnvironment env) {
        DataSet dataSet;
        if (this.fileOutput()) {
            String x$1 = this.documentsPath();
            String x$2 = "|";
            int[] x$3 = new int[]{0, 1};
            String x$4 = env.readCsvFile$default$2();
            Character x$5 = env.readCsvFile$default$4();
            boolean x$6 = env.readCsvFile$default$5();
            String x$7 = env.readCsvFile$default$6();
            boolean x$8 = env.readCsvFile$default$7();
            String[] x$9 = env.readCsvFile$default$9();
            dataSet = env.readCsvFile(x$1, x$4, x$2, x$5, x$6, x$7, x$8, x$3, x$9, ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<String, String>>(){

                public TypeInformation<?>[] protected$types(anon.11 x$1) {
                    return x$1.types;
                }

                public Class<Tuple2<String, String>> protected$tupleType(anon.11 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.11 $outer;
                        private final ExecutionConfig executionConfig$3;
                        private final TypeSerializer[] fieldSerializers$3;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$3 = executionConfig$3;
                            this.fieldSerializers$3 = fieldSerializers$3;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                        public Tuple2<String, String> createInstance(Object[] fields) {
                            return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                        }
                    };
                }
            });
        } else {
            Tuple2[] documents = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])WebLogData.DOCUMENTS).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Object[] x0$1) {
                    Object[] objectArray = x0$1;
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        Object x = ((SeqLike)option.get()).apply(0);
                        Object y = ((SeqLike)option.get()).apply(1);
                        Tuple2 tuple2 = new Tuple2((Object)((String)x), (Object)((String)y));
                        return tuple2;
                    }
                    throw new MatchError((Object)objectArray);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            dataSet = env.fromCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])documents), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<String, String>>(){

                public TypeInformation<?>[] protected$types(anon.12 x$1) {
                    return x$1.types;
                }

                public Class<Tuple2<String, String>> protected$tupleType(anon.12 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.12 $outer;
                        private final ExecutionConfig executionConfig$4;
                        private final TypeSerializer[] fieldSerializers$4;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$4 = executionConfig$4;
                            this.fieldSerializers$4 = fieldSerializers$4;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                        public Tuple2<String, String> createInstance(Object[] fields) {
                            return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                        }
                    };
                }
            });
        }
        return dataSet;
    }

    private DataSet<Tuple3<Object, String, Object>> getRanksDataSet(ExecutionEnvironment env) {
        DataSet dataSet;
        if (this.fileOutput()) {
            String x$10 = this.ranksPath();
            String x$11 = "|";
            int[] x$12 = new int[]{0, 1, 2};
            String x$13 = env.readCsvFile$default$2();
            Character x$14 = env.readCsvFile$default$4();
            boolean x$15 = env.readCsvFile$default$5();
            String x$16 = env.readCsvFile$default$6();
            boolean x$17 = env.readCsvFile$default$7();
            String[] x$18 = env.readCsvFile$default$9();
            dataSet = env.readCsvFile(x$10, x$13, x$11, x$14, x$15, x$16, x$17, x$12, x$18, ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(){

                public TypeInformation<?>[] protected$types(anon.13 x$1) {
                    return x$1.types;
                }

                public Class<Tuple3<Object, String, Object>> protected$tupleType(anon.13 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.13 $outer;
                        private final ExecutionConfig executionConfig$5;
                        private final TypeSerializer[] fieldSerializers$5;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$5 = executionConfig$5;
                            this.fieldSerializers$5 = fieldSerializers$5;
                        }
                    });
                    return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                        }
                    };
                }
            });
        } else {
            Tuple3[] ranks = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])WebLogData.RANKS).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple3<Object, String, Object> apply(Object[] x0$2) {
                    Object[] objectArray = x0$2;
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
                        Object x = ((SeqLike)option.get()).apply(0);
                        Object y = ((SeqLike)option.get()).apply(1);
                        Object z = ((SeqLike)option.get()).apply(2);
                        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x)), (Object)((String)y), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)z)));
                        return tuple3;
                    }
                    throw new MatchError((Object)objectArray);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            dataSet = env.fromCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])ranks), ClassTag$.MODULE$.apply(Tuple3.class), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, String, Object>>(){

                public TypeInformation<?>[] protected$types(anon.14 x$1) {
                    return x$1.types;
                }

                public Class<Tuple3<Object, String, Object>> protected$tupleType(anon.14 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.14 $outer;
                        private final ExecutionConfig executionConfig$6;
                        private final TypeSerializer[] fieldSerializers$6;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$6 = executionConfig$6;
                            this.fieldSerializers$6 = fieldSerializers$6;
                        }
                    });
                    return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                        public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                        }
                    };
                }
            });
        }
        return dataSet;
    }

    private DataSet<Tuple2<String, String>> getVisitsDataSet(ExecutionEnvironment env) {
        DataSet dataSet;
        if (this.fileOutput()) {
            String x$19 = this.visitsPath();
            String x$20 = "|";
            int[] x$21 = new int[]{1, 2};
            String x$22 = env.readCsvFile$default$2();
            Character x$23 = env.readCsvFile$default$4();
            boolean x$24 = env.readCsvFile$default$5();
            String x$25 = env.readCsvFile$default$6();
            boolean x$26 = env.readCsvFile$default$7();
            String[] x$27 = env.readCsvFile$default$9();
            dataSet = env.readCsvFile(x$19, x$22, x$20, x$23, x$24, x$25, x$26, x$21, x$27, ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<String, String>>(){

                public TypeInformation<?>[] protected$types(anon.15 x$1) {
                    return x$1.types;
                }

                public Class<Tuple2<String, String>> protected$tupleType(anon.15 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.15 $outer;
                        private final ExecutionConfig executionConfig$7;
                        private final TypeSerializer[] fieldSerializers$7;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$7 = executionConfig$7;
                            this.fieldSerializers$7 = fieldSerializers$7;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                        public Tuple2<String, String> createInstance(Object[] fields) {
                            return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                        }
                    };
                }
            });
        } else {
            Tuple2[] visits = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])WebLogData.VISITS).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Object[] x0$3) {
                    Object[] objectArray = x0$3;
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        Object x = ((SeqLike)option.get()).apply(0);
                        Object y = ((SeqLike)option.get()).apply(1);
                        Tuple2 tuple2 = new Tuple2((Object)((String)x), (Object)((String)y));
                        return tuple2;
                    }
                    throw new MatchError((Object)objectArray);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            dataSet = env.fromCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])visits), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<String, String>>(){

                public TypeInformation<?>[] protected$types(anon.16 x$1) {
                    return x$1.types;
                }

                public Class<Tuple2<String, String>> protected$tupleType(anon.16 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple2<String, String>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.16 $outer;
                        private final ExecutionConfig executionConfig$8;
                        private final TypeSerializer[] fieldSerializers$8;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$8 = executionConfig$8;
                            this.fieldSerializers$8 = fieldSerializers$8;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<String, String>>(this, fieldSerializers){

                        public Tuple2<String, String> createInstance(Object[] fields) {
                            return new Tuple2((Object)((String)fields[0]), (Object)((String)fields[1]));
                        }
                    };
                }
            });
        }
        return dataSet;
    }

    private WebLogAnalysis$() {
        MODULE$ = this;
        this.fileOutput = false;
        this.documentsPath = null;
        this.ranksPath = null;
        this.visitsPath = null;
        this.outputPath = null;
    }
}

