/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.scala.graph;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.AggregateDataSet;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.JoinDataSet;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.examples.java.graph.util.ConnectedComponentsData;
import org.apache.flink.examples.scala.graph.ConnectedComponents$;
import org.apache.flink.examples.scala.graph.ConnectedComponents$$anonfun$3$;
import org.apache.flink.util.Collector;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ConnectedComponents$ {
    public static final ConnectedComponents$ MODULE$;
    private boolean fileOutput;
    private String verticesPath;
    private String edgesPath;
    private int maxIterations;
    private String outputPath;

    static {
        new ConnectedComponents$();
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            DataSet vertices = this.getVerticesDataSet(env).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(long id) {
                    return new Tuple2.mcJJ.sp(id, id);
                }
            }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(){

                public TypeInformation<?>[] protected$types(anon.9 x$1) {
                    return x$1.types;
                }

                public Class<Tuple2<Object, Object>> protected$tupleType(anon.9 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.9 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                        public Tuple2<Object, Object> createInstance(Object[] fields) {
                            return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)).withForwardedFields((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*->_1;*->_2"}));
            DataSet edges = this.getEdgesDataSet(env).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Tuple2<Object, Object>> apply(Tuple2<Object, Object> edge) {
                    return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{edge, new Tuple2.mcJJ.sp(edge._2$mcJ$sp(), edge._1$mcJ$sp())}));
                }
            }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(){

                public TypeInformation<?>[] protected$types(anon.10 x$1) {
                    return x$1.types;
                }

                public Class<Tuple2<Object, Object>> protected$tupleType(anon.10 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.10 $outer;
                        private final ExecutionConfig executionConfig$2;
                        private final TypeSerializer[] fieldSerializers$2;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$2 = executionConfig$2;
                            this.fieldSerializers$2 = fieldSerializers$2;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                        public Tuple2<Object, Object> createInstance(Object[] fields) {
                            return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            DataSet verticesWithComponents = vertices.iterateDelta(vertices, this.maxIterations(), (String[])((Object[])new String[]{"_1"}), (Function2)new Serializable(edges){
                public static final long serialVersionUID = 0L;
                private final DataSet edges$1;

                public final Tuple2<DataSet<Tuple2<Object, Object>>, DataSet<Tuple2<Object, Object>>> apply(DataSet<Tuple2<Object, Object>> s, DataSet<Tuple2<Object, Object>> ws) {
                    DataSet allNeighbors = ((JoinDataSet)ws.join(this.edges$1).where((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).equalTo((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))).apply((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Object> apply(Tuple2<Object, Object> vertex, Tuple2<Object, Object> edge) {
                            return new Tuple2.mcJJ.sp(edge._2$mcJ$sp(), vertex._2$mcJ$sp());
                        }
                    }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(this){

                        public TypeInformation<?>[] protected$types(anonfun$3$$anon$11 x$1) {
                            return x$1.types;
                        }

                        public Class<Tuple2<Object, Object>> protected$tupleType(anonfun$3$$anon$11 x$1) {
                            return x$1.tupleType;
                        }

                        public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$3$$anon$11 $outer;
                                private final ExecutionConfig executionConfig$3;
                                private final TypeSerializer[] fieldSerializers$3;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.executionConfig$3 = executionConfig$3;
                                    this.fieldSerializers$3 = fieldSerializers$3;
                                }
                            });
                            return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                                public Tuple2<Object, Object> createInstance(Object[] fields) {
                                    return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                                }
                            };
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class)).withForwardedFieldsFirst((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_2->_2"})).withForwardedFieldsSecond((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_2->_1"}));
                    AggregateDataSet minNeighbors = allNeighbors.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).min(1);
                    DataSet updatedComponents = ((JoinDataSet)minNeighbors.join(s).where((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).equalTo((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))).apply((Function3)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> newVertex, Tuple2<Object, Object> oldVertex, Collector<Tuple2<Object, Object>> out) {
                            if (newVertex._2$mcJ$sp() < oldVertex._2$mcJ$sp()) {
                                out.collect(newVertex);
                            }
                        }
                    }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(this){

                        public TypeInformation<?>[] protected$types(anonfun$3$$anon$12 x$1) {
                            return x$1.types;
                        }

                        public Class<Tuple2<Object, Object>> protected$tupleType(anonfun$3$$anon$12 x$1) {
                            return x$1.tupleType;
                        }

                        public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$3$$anon$12 $outer;
                                private final ExecutionConfig executionConfig$4;
                                private final TypeSerializer[] fieldSerializers$4;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.executionConfig$4 = executionConfig$4;
                                    this.fieldSerializers$4 = fieldSerializers$4;
                                }
                            });
                            return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                                public Tuple2<Object, Object> createInstance(Object[] fields) {
                                    return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                                }
                            };
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class)).withForwardedFieldsFirst((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*"}));
                    return new Tuple2((Object)updatedComponents, (Object)updatedComponents);
                }
                {
                    this.edges$1 = edges$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            if (this.fileOutput()) {
                verticesWithComponents.writeAsCsv(this.outputPath(), "\n", " ", verticesWithComponents.writeAsCsv$default$4());
                env.execute("Scala Connected Components Example");
            } else {
                verticesWithComponents.print();
            }
            return;
        }
    }

    private boolean parseParameters(String[] args) {
        boolean bl;
        if (args.length > 0) {
            this.fileOutput_$eq(true);
            if (args.length == 4) {
                this.verticesPath_$eq(args[0]);
                this.edgesPath_$eq(args[1]);
                this.outputPath_$eq(args[2]);
                this.maxIterations_$eq(new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt());
                bl = true;
            } else {
                System.err.println("Usage: ConnectedComponents <vertices path> <edges path> <result path> <max number of iterations>");
                bl = false;
            }
        } else {
            System.out.println("Executing Connected Components example with built-in default data.");
            System.out.println("  Provide parameters to read input data from a file.");
            System.out.println("  Usage: ConnectedComponents <vertices path> <edges path> <result path> <max number of iterations>");
            bl = true;
        }
        return bl;
    }

    private DataSet<Object> getVerticesDataSet(ExecutionEnvironment env) {
        DataSet dataSet;
        if (this.fileOutput()) {
            String x$1 = this.verticesPath();
            int[] x$2 = new int[]{0};
            String x$3 = env.readCsvFile$default$2();
            String x$4 = env.readCsvFile$default$3();
            Character x$5 = env.readCsvFile$default$4();
            boolean x$6 = env.readCsvFile$default$5();
            String x$7 = env.readCsvFile$default$6();
            boolean x$8 = env.readCsvFile$default$7();
            String[] x$9 = env.readCsvFile$default$9();
            dataSet = env.readCsvFile(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$2, x$9, ClassTag$.MODULE$.apply(Tuple1.class), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(){

                public TypeInformation<?>[] protected$types(anon.13 x$1) {
                    return x$1.types;
                }

                public Class<Tuple1<Object>> protected$tupleType(anon.13 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.13 $outer;
                        private final ExecutionConfig executionConfig$5;
                        private final TypeSerializer[] fieldSerializers$5;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$5 = executionConfig$5;
                            this.fieldSerializers$5 = fieldSerializers$5;
                        }
                    });
                    return new CaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                        public Tuple1<Object> createInstance(Object[] fields) {
                            return new Tuple1.mcJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]));
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple1<Object> x) {
                    return x._1$mcJ$sp();
                }
            }, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        } else {
            dataSet = env.fromCollection((Seq)Predef$.MODULE$.wrapLongArray(ConnectedComponentsData.VERTICES), ClassTag$.MODULE$.Long(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE));
        }
        return dataSet;
    }

    private DataSet<Tuple2<Object, Object>> getEdgesDataSet(ExecutionEnvironment env) {
        DataSet dataSet;
        if (this.fileOutput()) {
            String x$10 = this.edgesPath();
            String x$11 = " ";
            int[] x$12 = new int[]{0, 1};
            String x$13 = env.readCsvFile$default$2();
            Character x$14 = env.readCsvFile$default$4();
            boolean x$15 = env.readCsvFile$default$5();
            String x$16 = env.readCsvFile$default$6();
            boolean x$17 = env.readCsvFile$default$7();
            String[] x$18 = env.readCsvFile$default$9();
            dataSet = env.readCsvFile(x$10, x$13, x$11, x$14, x$15, x$16, x$17, x$12, x$18, ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(){

                public TypeInformation<?>[] protected$types(anon.14 x$1) {
                    return x$1.types;
                }

                public Class<Tuple2<Object, Object>> protected$tupleType(anon.14 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.14 $outer;
                        private final ExecutionConfig executionConfig$6;
                        private final TypeSerializer[] fieldSerializers$6;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$6 = executionConfig$6;
                            this.fieldSerializers$6 = fieldSerializers$6;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                        public Tuple2<Object, Object> createInstance(Object[] fields) {
                            return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x) {
                    return new Tuple2.mcJJ.sp(x._1$mcJ$sp(), x._2$mcJ$sp());
                }
            }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(){

                public TypeInformation<?>[] protected$types(anon.15 x$1) {
                    return x$1.types;
                }

                public Class<Tuple2<Object, Object>> protected$tupleType(anon.15 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.15 $outer;
                        private final ExecutionConfig executionConfig$7;
                        private final TypeSerializer[] fieldSerializers$7;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$7 = executionConfig$7;
                            this.fieldSerializers$7 = fieldSerializers$7;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                        public Tuple2<Object, Object> createInstance(Object[] fields) {
                            return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
        } else {
            Tuple2[] edgeData = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])ConnectedComponentsData.EDGES).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(Object[] x0$1) {
                    Object[] objectArray = x0$1;
                    Option option = Array$.MODULE$.unapplySeq((Object)objectArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        Object x = ((SeqLike)option.get()).apply(0);
                        Object y = ((SeqLike)option.get()).apply(1);
                        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)x), BoxesRunTime.unboxToLong((Object)y));
                        return sp2;
                    }
                    throw new MatchError((Object)objectArray);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            dataSet = env.fromCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])edgeData), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(){

                public TypeInformation<?>[] protected$types(anon.16 x$1) {
                    return x$1.types;
                }

                public Class<Tuple2<Object, Object>> protected$tupleType(anon.16 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.16 $outer;
                        private final ExecutionConfig executionConfig$8;
                        private final TypeSerializer[] fieldSerializers$8;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$8 = executionConfig$8;
                            this.fieldSerializers$8 = fieldSerializers$8;
                        }
                    });
                    return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                        public Tuple2<Object, Object> createInstance(Object[] fields) {
                            return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                        }
                    };
                }
            });
        }
        return dataSet;
    }

    private boolean fileOutput() {
        return this.fileOutput;
    }

    private void fileOutput_$eq(boolean x$1) {
        this.fileOutput = x$1;
    }

    private String verticesPath() {
        return this.verticesPath;
    }

    private void verticesPath_$eq(String x$1) {
        this.verticesPath = x$1;
    }

    private String edgesPath() {
        return this.edgesPath;
    }

    private void edgesPath_$eq(String x$1) {
        this.edgesPath = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private String outputPath() {
        return this.outputPath;
    }

    private void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    private ConnectedComponents$() {
        MODULE$ = this;
        this.fileOutput = false;
        this.verticesPath = null;
        this.edgesPath = null;
        this.maxIterations = 10;
        this.outputPath = null;
    }
}

