/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.znerd.xmlenc.sax;

import java.io.IOException;
import org.apache.flink.fs.s3hadoop.shaded.org.znerd.xmlenc.XMLEventListener;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXEventReceiver
implements ContentHandler {
    private final XMLEventListener _eventListener;

    public SAXEventReceiver(XMLEventListener xMLEventListener) throws IllegalArgumentException {
        if (xMLEventListener == null) {
            throw new IllegalArgumentException("eventListener == null");
        }
        this._eventListener = xMLEventListener;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        try {
            this._eventListener.endDocument();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this._eventListener.startTag(string3);
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                this._eventListener.attribute(attributes.getQName(i), attributes.getValue(i));
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this._eventListener.endTag();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this._eventListener.pcdata(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        try {
            this._eventListener.whitespace(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this._eventListener.pi(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }
}

