/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.znerd.xmlenc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.flink.fs.s3hadoop.shaded.org.znerd.xmlenc.InvalidXMLException;
import org.apache.flink.fs.s3hadoop.shaded.org.znerd.xmlenc.LineBreak;
import org.apache.flink.fs.s3hadoop.shaded.org.znerd.xmlenc.StatefulXMLEventListener;
import org.apache.flink.fs.s3hadoop.shaded.org.znerd.xmlenc.XMLChecker;
import org.apache.flink.fs.s3hadoop.shaded.org.znerd.xmlenc.XMLEncoder;
import org.apache.flink.fs.s3hadoop.shaded.org.znerd.xmlenc.XMLEventListenerState;
import org.apache.flink.fs.s3hadoop.shaded.org.znerd.xmlenc.XMLEventListenerStates;

public class XMLOutputter
implements StatefulXMLEventListener {
    public static final String DEFAULT_INDENTATION = "";
    private boolean _anythingOutput;
    private Writer _out;
    private XMLEncoder _encoder;
    private XMLEventListenerState _state;
    private String[] _elementStack;
    private int _elementStackSize;
    private char _quotationMark;
    private boolean _escapeAmpersands = true;
    private LineBreak _lineBreak = LineBreak.NONE;
    private char[] _lineBreakChars;
    private String _indentation;

    public XMLOutputter() {
        this._lineBreakChars = this._lineBreak._lineBreakChars;
        this._state = XMLEventListenerStates.UNINITIALIZED;
        this._elementStack = new String[16];
        this._quotationMark = (char)34;
        this._escapeAmpersands = true;
        this._lineBreak = LineBreak.NONE;
        this._lineBreakChars = this._lineBreak._lineBreakChars;
        this._indentation = DEFAULT_INDENTATION;
    }

    public XMLOutputter(Writer writer, String string) throws IllegalStateException, IllegalArgumentException, UnsupportedEncodingException {
        this();
        this.reset(writer, string);
    }

    public XMLOutputter(Writer writer, XMLEncoder xMLEncoder) throws IllegalStateException, IllegalArgumentException, UnsupportedEncodingException {
        this();
        this.reset(writer, xMLEncoder);
    }

    private final void checkInvariants() throws Error {
        if (this._lineBreak == null) {
            throw new Error("_lineBreak == null");
        }
        if (this._lineBreak == LineBreak.NONE && this._indentation.length() > 0) {
            throw new Error("_lineBreak == LineBreak.NONE && _indentation = \"" + this._indentation + "\".");
        }
    }

    private final void writeIndentation() throws IOException {
        if (this._indentation.length() > 0) {
            int n = this._elementStackSize - 1;
            for (int i = 0; i < n; ++i) {
                this._out.write(this._indentation);
            }
        }
    }

    public final Writer getWriter() {
        return this._out;
    }

    public final String getEncoding() {
        if (this._encoder == null) {
            return null;
        }
        return this._encoder.getEncoding();
    }

    public void reset() {
        this._out = null;
        this._encoder = null;
        this._elementStackSize = 0;
        this._state = XMLEventListenerStates.UNINITIALIZED;
        this._lineBreak = LineBreak.NONE;
        this._lineBreakChars = this._lineBreak._lineBreakChars;
        this._indentation = DEFAULT_INDENTATION;
        this.checkInvariants();
    }

    private final void reset(Writer writer) throws IllegalArgumentException {
        if (writer == null) {
            throw new IllegalArgumentException("out == null");
        }
        this._out = writer;
        this._state = XMLEventListenerStates.BEFORE_XML_DECLARATION;
        this._elementStackSize = 0;
        this._lineBreak = LineBreak.NONE;
        this._lineBreakChars = this._lineBreak._lineBreakChars;
        this._indentation = DEFAULT_INDENTATION;
        this.checkInvariants();
    }

    public final void reset(Writer writer, String string) throws IllegalArgumentException, UnsupportedEncodingException {
        if (string == null) {
            throw new IllegalArgumentException("encoding == null");
        }
        this.reset(writer);
        this._encoder = XMLEncoder.getEncoder(string);
        this.checkInvariants();
    }

    public final void reset(Writer writer, XMLEncoder xMLEncoder) throws IllegalArgumentException, UnsupportedEncodingException {
        if (xMLEncoder == null) {
            throw new IllegalArgumentException("encoder == null");
        }
        this.reset(writer);
        this._encoder = xMLEncoder;
        this.checkInvariants();
    }

    public final void setState(XMLEventListenerState xMLEventListenerState, String[] stringArray) throws IllegalArgumentException {
        if (xMLEventListenerState == null) {
            throw new IllegalArgumentException("newState == null");
        }
        if (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN && stringArray == null) {
            throw new IllegalArgumentException("newState == START_TAG_OPEN && newElementStack == null");
        }
        if (xMLEventListenerState == XMLEventListenerStates.WITHIN_ELEMENT && stringArray == null) {
            throw new IllegalArgumentException("newState == WITHIN_ELEMENT && newElementStack == null");
        }
        if (xMLEventListenerState != XMLEventListenerStates.START_TAG_OPEN && xMLEventListenerState != XMLEventListenerStates.WITHIN_ELEMENT && stringArray != null) {
            throw new IllegalArgumentException("newState != START_TAG_OPEN && newState != WITHIN_ELEMENT && newElementStack != null");
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) continue;
                throw new IllegalArgumentException("newElementStack[" + i + "] == null");
            }
            if (stringArray.length > this._elementStack.length) {
                try {
                    this._elementStack = new String[stringArray.length + 16];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this._elementStack = new String[stringArray.length];
                }
            }
            System.arraycopy(stringArray, 0, this._elementStack, 0, stringArray.length);
        }
        if (xMLEventListenerState == XMLEventListenerStates.UNINITIALIZED) {
            this.reset();
        } else {
            this._state = xMLEventListenerState;
            this._elementStackSize = stringArray == null ? 0 : stringArray.length;
        }
        this.checkInvariants();
    }

    public final XMLEventListenerState getState() {
        return this._state;
    }

    public final boolean isEscaping() {
        return this._escapeAmpersands;
    }

    public final void setEscaping(boolean bl) {
        this._escapeAmpersands = bl;
        this.checkInvariants();
    }

    public final String[] getElementStack() {
        if (this._elementStackSize == 0) {
            return null;
        }
        String[] stringArray = new String[this._elementStackSize];
        System.arraycopy(this._elementStack, 0, stringArray, 0, this._elementStackSize);
        return stringArray;
    }

    public final int getElementStackSize() {
        return this._elementStackSize;
    }

    public final int getElementStackCapacity() {
        return this._elementStack.length;
    }

    public final void setElementStackCapacity(int n) throws IllegalArgumentException, OutOfMemoryError {
        if (n < this._elementStack.length) {
            throw new IllegalArgumentException("newCapacity < getElementStackSize()");
        }
        int n2 = this._elementStack.length;
        if (n2 == n) {
            return;
        }
        String[] stringArray = new String[n];
        System.arraycopy(this._elementStack, 0, stringArray, 0, this._elementStackSize);
        this._elementStack = stringArray;
        this.checkInvariants();
    }

    public final void setQuotationMark(char c) throws IllegalArgumentException {
        if (c != '\'' && c != '\"') {
            throw new IllegalArgumentException("c != '\\'' && c != '\"'");
        }
        this._quotationMark = c;
        this.checkInvariants();
    }

    public final char getQuotationMark() {
        return this._quotationMark;
    }

    public final void setLineBreak(LineBreak lineBreak) {
        this._lineBreak = lineBreak != null ? lineBreak : LineBreak.NONE;
        this._lineBreakChars = this._lineBreak._lineBreakChars;
        if (this._lineBreak == LineBreak.NONE) {
            this._indentation = DEFAULT_INDENTATION;
        }
        this.checkInvariants();
    }

    public final LineBreak getLineBreak() {
        return this._lineBreak;
    }

    public final void setIndentation(String string) throws IllegalStateException {
        String string2 = string = string != null ? string : DEFAULT_INDENTATION;
        if (this._lineBreak == LineBreak.NONE) {
            throw new IllegalStateException("getLineBreak() == LineBreak.NONE");
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t') continue;
            String string3 = "indentation.charAt(" + i + ") = " + c + ", while only space and tab are allowed.";
            throw new IllegalArgumentException(string3);
        }
        this._indentation = string;
        this.checkInvariants();
    }

    public final String getIndentation() {
        return this._indentation;
    }

    private void closeStartTag() throws IOException {
        this._out.write(62);
    }

    public final void declaration() throws IllegalStateException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        this._state = XMLEventListenerStates.ERROR_STATE;
        this._encoder.declaration(this._out);
        this._state = XMLEventListenerStates.BEFORE_DTD_DECLARATION;
        this.checkInvariants();
    }

    public final void dtd(String string, String string2, String string3) throws IllegalStateException, IllegalArgumentException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (string == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (string2 != null && string3 == null) {
            throw new IllegalArgumentException("Found public identifier, but no system identifier.");
        }
        XMLChecker.checkName(string);
        if (string2 != null) {
            XMLChecker.checkPubidLiteral("\"" + string2 + "\"");
        }
        if (string3 != null) {
            XMLChecker.checkSystemLiteral("\"" + string3 + "\"");
        }
        XMLEventListenerState xMLEventListenerState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (xMLEventListenerState == XMLEventListenerStates.BEFORE_DTD_DECLARATION) {
            this._out.write(this._lineBreakChars);
        }
        this._out.write("<!DOCTYPE ");
        this._out.write(string);
        if (string2 != null) {
            this._out.write(" PUBLIC \"");
            this._out.write(string2);
            this._out.write(34);
            this._out.write(32);
            this._out.write(34);
            this._out.write(string3);
            this._out.write(34);
        } else if (string3 != null) {
            this._out.write(" SYSTEM \"");
            this._out.write(string3);
            this._out.write(34);
        }
        this.closeStartTag();
        this._state = XMLEventListenerStates.BEFORE_ROOT_ELEMENT;
        this.checkInvariants();
    }

    public final void startTag(String string) throws IllegalStateException, IllegalArgumentException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION && this._state != XMLEventListenerStates.BEFORE_ROOT_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (string == null) {
            throw new IllegalArgumentException("type == null");
        }
        XMLEventListenerState xMLEventListenerState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (this._elementStackSize == this._elementStack.length) {
            String[] stringArray;
            try {
                stringArray = new String[(this._elementStackSize + 1) * 2];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                stringArray = new String[this._elementStackSize + 1];
            }
            System.arraycopy(this._elementStack, 0, stringArray, 0, this._elementStackSize);
            this._elementStack = stringArray;
        }
        this._elementStack[this._elementStackSize] = string;
        ++this._elementStackSize;
        if (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN) {
            this._out.write(62);
        }
        if (xMLEventListenerState != XMLEventListenerStates.BEFORE_XML_DECLARATION) {
            this._out.write(this._lineBreakChars);
            this.writeIndentation();
        }
        this._out.write(60);
        this._out.write(string);
        this._state = XMLEventListenerStates.START_TAG_OPEN;
        this.checkInvariants();
    }

    public final void attribute(String string, String string2) throws IllegalStateException, IllegalArgumentException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (string == null || string2 == null) {
            if (string == null && string2 == null) {
                throw new IllegalArgumentException("name == null && value == null");
            }
            if (string == null) {
                throw new IllegalArgumentException("name == null");
            }
            throw new IllegalArgumentException("value == null");
        }
        this._state = XMLEventListenerStates.ERROR_STATE;
        this._encoder.attribute(this._out, string, string2, this._quotationMark, this._escapeAmpersands);
        this._state = XMLEventListenerStates.START_TAG_OPEN;
        this.checkInvariants();
    }

    public final void endTag() throws IllegalStateException, IOException {
        if (this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        XMLEventListenerState xMLEventListenerState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        String string = this._elementStack[this._elementStackSize - 1];
        if (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN) {
            this._out.write(47);
            this._out.write(62);
        } else {
            this._out.write(this._lineBreakChars);
            this.writeIndentation();
            this._out.write(60);
            this._out.write(47);
            this._out.write(string);
            this.closeStartTag();
        }
        --this._elementStackSize;
        this._state = this._elementStackSize == 0 ? XMLEventListenerStates.AFTER_ROOT_ELEMENT : XMLEventListenerStates.WITHIN_ELEMENT;
        this.checkInvariants();
    }

    public final void pcdata(String string) throws IllegalStateException, IllegalArgumentException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (string == null) {
            throw new IllegalArgumentException("text == null");
        }
        XMLEventListenerState xMLEventListenerState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
            this._out.write(this._lineBreakChars);
        }
        this._encoder.text(this._out, string, this._escapeAmpersands);
        this._state = XMLEventListenerStates.WITHIN_ELEMENT;
        this.checkInvariants();
    }

    public final void pcdata(char[] cArray, int n, int n2) throws IllegalStateException, IllegalArgumentException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (cArray == null) {
            throw new IllegalArgumentException("ch == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("start (" + n + ") < 0");
        }
        if (n >= cArray.length) {
            throw new IllegalArgumentException("start (" + n + ") >= ch.length (" + cArray.length + ')');
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        XMLEventListenerState xMLEventListenerState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
        }
        this._encoder.text(this._out, cArray, n, n2, this._escapeAmpersands);
        this._state = XMLEventListenerStates.WITHIN_ELEMENT;
        this.checkInvariants();
    }

    public final void whitespace(String string) throws IllegalStateException, IllegalArgumentException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION && this._state != XMLEventListenerStates.BEFORE_ROOT_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (string == null) {
            throw new IllegalArgumentException("whitespace == null");
        }
        XMLEventListenerState xMLEventListenerState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
        }
        this._encoder.whitespace(this._out, string);
        this._state = xMLEventListenerState == XMLEventListenerStates.BEFORE_XML_DECLARATION ? XMLEventListenerStates.BEFORE_DTD_DECLARATION : (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN ? XMLEventListenerStates.WITHIN_ELEMENT : xMLEventListenerState);
        this.checkInvariants();
    }

    public final void whitespace(char[] cArray, int n, int n2) throws IllegalStateException, IllegalArgumentException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION && this._state != XMLEventListenerStates.BEFORE_ROOT_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (cArray == null) {
            throw new IllegalArgumentException("ch == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("start (" + n + ") < 0");
        }
        if (n >= cArray.length) {
            throw new IllegalArgumentException("start (" + n + ") >= ch.length (" + cArray.length + ')');
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        XMLEventListenerState xMLEventListenerState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
        }
        this._encoder.whitespace(this._out, cArray, n, n2);
        this._state = xMLEventListenerState == XMLEventListenerStates.BEFORE_XML_DECLARATION ? XMLEventListenerStates.BEFORE_DTD_DECLARATION : (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN ? XMLEventListenerStates.WITHIN_ELEMENT : xMLEventListenerState);
        this.checkInvariants();
    }

    public final void comment(String string) throws IllegalStateException, IllegalArgumentException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION && this._state != XMLEventListenerStates.BEFORE_ROOT_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (string == null) {
            throw new IllegalArgumentException("text == null");
        }
        XMLEventListenerState xMLEventListenerState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN) {
            this._out.write(62);
            this._out.write(60);
            this._out.write(33);
            this._out.write(45);
            this._out.write(45);
        } else {
            this._out.write(60);
            this._out.write(33);
            this._out.write(45);
            this._out.write(45);
        }
        this._encoder.text(this._out, string, this._escapeAmpersands);
        this._out.write(45);
        this._out.write(45);
        this._out.write(62);
        this._out.write(this._lineBreakChars);
        this._state = xMLEventListenerState == XMLEventListenerStates.BEFORE_XML_DECLARATION ? XMLEventListenerStates.BEFORE_DTD_DECLARATION : (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN ? XMLEventListenerStates.WITHIN_ELEMENT : xMLEventListenerState);
        this.checkInvariants();
    }

    public final void pi(String string, String string2) throws IllegalStateException, IllegalArgumentException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION && this._state != XMLEventListenerStates.BEFORE_ROOT_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (string == null) {
            throw new IllegalArgumentException("target == null");
        }
        XMLEventListenerState xMLEventListenerState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
        }
        this._out.write(60);
        this._out.write(63);
        this._out.write(string);
        if (string2 != null) {
            this._out.write(32);
            this._out.write(string2);
        }
        this._out.write(63);
        this._out.write(62);
        this._state = xMLEventListenerState == XMLEventListenerStates.BEFORE_XML_DECLARATION ? XMLEventListenerStates.BEFORE_DTD_DECLARATION : (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN ? XMLEventListenerStates.WITHIN_ELEMENT : xMLEventListenerState);
        this.checkInvariants();
    }

    public final void cdata(String string) throws IllegalStateException, IllegalArgumentException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (string == null) {
            throw new IllegalArgumentException("text == null");
        }
        XMLEventListenerState xMLEventListenerState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (xMLEventListenerState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
        }
        this._out.write("<![CDATA[");
        this._out.write(string);
        this._out.write(93);
        this._out.write(93);
        this._out.write(62);
        this._state = XMLEventListenerStates.WITHIN_ELEMENT;
        this.checkInvariants();
    }

    public final void close() throws IllegalStateException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        while (this._elementStackSize > 0) {
            this.endTag();
        }
        this.checkInvariants();
    }

    public final void endDocument() throws IllegalStateException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        this.close();
        this._out.flush();
        this._state = XMLEventListenerStates.DOCUMENT_ENDED;
        this.checkInvariants();
    }
}

