/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.Time;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class AsyncDiskService {
    public static final Log LOG = LogFactory.getLog(AsyncDiskService.class);
    private static final int CORE_THREADS_PER_VOLUME = 1;
    private static final int MAXIMUM_THREADS_PER_VOLUME = 4;
    private static final long THREADS_KEEP_ALIVE_SECONDS = 60L;
    private final ThreadGroup threadGroup = new ThreadGroup("async disk service");
    private ThreadFactory threadFactory;
    private HashMap<String, ThreadPoolExecutor> executors = new HashMap();

    public AsyncDiskService(String[] volumes) {
        this.threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(AsyncDiskService.this.threadGroup, r);
            }
        };
        for (int v = 0; v < volumes.length; ++v) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.threadFactory);
            executor.allowCoreThreadTimeOut(true);
            this.executors.put(volumes[v], executor);
        }
    }

    public synchronized void execute(String root, Runnable task) {
        ThreadPoolExecutor executor = this.executors.get(root);
        if (executor == null) {
            throw new RuntimeException("Cannot find root " + root + " for execution of task " + task);
        }
        executor.execute(task);
    }

    public synchronized void shutdown() {
        LOG.info("Shutting down all AsyncDiskService threads...");
        for (Map.Entry<String, ThreadPoolExecutor> e : this.executors.entrySet()) {
            e.getValue().shutdown();
        }
    }

    public synchronized boolean awaitTermination(long milliseconds) throws InterruptedException {
        long end = Time.now() + milliseconds;
        for (Map.Entry<String, ThreadPoolExecutor> e : this.executors.entrySet()) {
            ThreadPoolExecutor executor = e.getValue();
            if (executor.awaitTermination(Math.max(end - Time.now(), 0L), TimeUnit.MILLISECONDS)) continue;
            LOG.warn("AsyncDiskService awaitTermination timeout.");
            return false;
        }
        LOG.info("All AsyncDiskService threads are terminated.");
        return true;
    }

    public synchronized List<Runnable> shutdownNow() {
        LOG.info("Shutting down all AsyncDiskService threads immediately...");
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        for (Map.Entry<String, ThreadPoolExecutor> e : this.executors.entrySet()) {
            list.addAll(e.getValue().shutdownNow());
        }
        return list;
    }
}

