/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Objects;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.Maps;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.metrics2.MetricsTag;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MetricsCache {
    static final Log LOG = LogFactory.getLog(MetricsCache.class);
    static final int MAX_RECS_PER_NAME_DEFAULT = 1000;
    private final Map<String, RecordCache> map = Maps.newHashMap();
    private final int maxRecsPerName;

    public MetricsCache() {
        this(1000);
    }

    public MetricsCache(int maxRecsPerName) {
        this.maxRecsPerName = maxRecsPerName;
    }

    public Record update(MetricsRecord mr, boolean includingTags) {
        Collection<MetricsTag> tags;
        Record record;
        String name = mr.name();
        RecordCache recordCache = this.map.get(name);
        if (recordCache == null) {
            recordCache = new RecordCache();
            this.map.put(name, recordCache);
        }
        if ((record = (Record)recordCache.get(tags = mr.tags())) == null) {
            record = new Record();
            recordCache.put(tags, record);
        }
        for (AbstractMetric m : mr.metrics()) {
            record.metrics.put(m.name(), m);
        }
        if (includingTags) {
            for (MetricsTag t : mr.tags()) {
                record.tags.put(t.name(), t.value());
            }
        }
        return record;
    }

    public Record update(MetricsRecord mr) {
        return this.update(mr, false);
    }

    public Record get(String name, Collection<MetricsTag> tags) {
        RecordCache rc = this.map.get(name);
        if (rc == null) {
            return null;
        }
        return (Record)rc.get(tags);
    }

    public static class Record {
        final Map<String, String> tags = Maps.newHashMap();
        final Map<String, AbstractMetric> metrics = Maps.newHashMap();

        public String getTag(String key) {
            return this.tags.get(key);
        }

        public Number getMetric(String key) {
            AbstractMetric metric = this.metrics.get(key);
            return metric != null ? (Number)metric.value() : (Number)null;
        }

        public AbstractMetric getMetricInstance(String key) {
            return this.metrics.get(key);
        }

        public Set<Map.Entry<String, String>> tags() {
            return this.tags.entrySet();
        }

        @Deprecated
        public Set<Map.Entry<String, Number>> metrics() {
            LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>(this.metrics.size());
            for (Map.Entry<String, AbstractMetric> mapEntry : this.metrics.entrySet()) {
                map.put(mapEntry.getKey(), mapEntry.getValue().value());
            }
            return map.entrySet();
        }

        public Set<Map.Entry<String, AbstractMetric>> metricsEntrySet() {
            return this.metrics.entrySet();
        }

        public String toString() {
            return Objects.toStringHelper(this).add("tags", this.tags).add("metrics", this.metrics).toString();
        }
    }

    class RecordCache
    extends LinkedHashMap<Collection<MetricsTag>, Record> {
        private static final long serialVersionUID = 1L;
        private boolean gotOverflow = false;

        RecordCache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Collection<MetricsTag>, Record> eldest) {
            boolean overflow;
            boolean bl = overflow = this.size() > MetricsCache.this.maxRecsPerName;
            if (overflow && !this.gotOverflow) {
                LOG.warn("Metrics cache overflow at " + this.size() + " for " + eldest);
                this.gotOverflow = true;
            }
            return overflow;
        }
    }
}

