/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.VersionMismatchException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.Writable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class VersionedWritable
implements Writable {
    public abstract byte getVersion();

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(this.getVersion());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version != this.getVersion()) {
            throw new VersionMismatchException(this.getVersion(), version);
        }
    }
}

