/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.DataInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.LayoutFlags;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageLoader;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.WritableUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.delegation.DelegationKey;

class ImageLoaderCurrent
implements ImageLoader {
    protected final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static int[] versions = new int[]{-16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -30, -31, -32, -33, -34, -35, -36, -37, -38, -39, -40, -41, -42, -43, -44, -45, -46, -47, -48, -49, -50, -51};
    private int imageVersion = 0;
    private final Map<Long, Boolean> subtreeMap = new HashMap<Long, Boolean>();
    private final Map<Long, String> dirNodeMap = new HashMap<Long, String>();

    ImageLoaderCurrent() {
    }

    @Override
    public boolean canLoadVersion(int version) {
        for (int v : versions) {
            if (v != version) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadImage(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        boolean done = false;
        try {
            boolean supportSnapshot;
            v.start();
            v.visitEnclosingElement(ImageVisitor.ImageElement.FS_IMAGE);
            this.imageVersion = in.readInt();
            if (!this.canLoadVersion(this.imageVersion)) {
                throw new IOException("Cannot process fslayout version " + this.imageVersion);
            }
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_LAYOUT_FLAGS, this.imageVersion)) {
                LayoutFlags.read(in);
            }
            v.visit(ImageVisitor.ImageElement.IMAGE_VERSION, this.imageVersion);
            v.visit(ImageVisitor.ImageElement.NAMESPACE_ID, in.readInt());
            long numInodes = in.readLong();
            v.visit(ImageVisitor.ImageElement.GENERATION_STAMP, in.readLong());
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.SEQUENTIAL_BLOCK_ID, this.imageVersion)) {
                v.visit(ImageVisitor.ImageElement.GENERATION_STAMP_V2, in.readLong());
                v.visit(ImageVisitor.ImageElement.GENERATION_STAMP_V1_LIMIT, in.readLong());
                v.visit(ImageVisitor.ImageElement.LAST_ALLOCATED_BLOCK_ID, in.readLong());
            }
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.STORED_TXIDS, this.imageVersion)) {
                v.visit(ImageVisitor.ImageElement.TRANSACTION_ID, in.readLong());
            }
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, this.imageVersion)) {
                v.visit(ImageVisitor.ImageElement.LAST_INODE_ID, in.readLong());
            }
            if (supportSnapshot = NameNodeLayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, this.imageVersion)) {
                v.visit(ImageVisitor.ImageElement.SNAPSHOT_COUNTER, in.readInt());
                int numSnapshots = in.readInt();
                v.visit(ImageVisitor.ImageElement.NUM_SNAPSHOTS_TOTAL, numSnapshots);
                for (int i = 0; i < numSnapshots; ++i) {
                    this.processSnapshot(in, v);
                }
            }
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_COMPRESSION, this.imageVersion)) {
                boolean isCompressed = in.readBoolean();
                v.visit(ImageVisitor.ImageElement.IS_COMPRESSED, String.valueOf(isCompressed));
                if (isCompressed) {
                    String codecClassName = Text.readString(in);
                    v.visit(ImageVisitor.ImageElement.COMPRESS_CODEC, codecClassName);
                    CompressionCodecFactory codecFac = new CompressionCodecFactory(new Configuration());
                    CompressionCodec codec = codecFac.getCodecByClassName(codecClassName);
                    if (codec == null) {
                        throw new IOException("Image compression codec not supported: " + codecClassName);
                    }
                    in = new DataInputStream(codec.createInputStream(in));
                }
            }
            this.processINodes(in, v, numInodes, skipBlocks, supportSnapshot);
            this.subtreeMap.clear();
            this.dirNodeMap.clear();
            this.processINodesUC(in, v, skipBlocks);
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.DELEGATION_TOKEN, this.imageVersion)) {
                this.processDelegationTokens(in, v);
            }
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.CACHING, this.imageVersion)) {
                this.processCacheManagerState(in, v);
            }
            v.leaveEnclosingElement();
            done = true;
        }
        finally {
            if (done) {
                v.finish();
            } else {
                v.finishAbnormally();
            }
        }
    }

    private void processCacheManagerState(DataInputStream in, ImageVisitor v) throws IOException {
        v.visit(ImageVisitor.ImageElement.CACHE_NEXT_ENTRY_ID, in.readLong());
        int numPools = in.readInt();
        for (int i = 0; i < numPools; ++i) {
            v.visit(ImageVisitor.ImageElement.CACHE_POOL_NAME, Text.readString(in));
            this.processCachePoolPermission(in, v);
            v.visit(ImageVisitor.ImageElement.CACHE_POOL_WEIGHT, in.readInt());
        }
        int numEntries = in.readInt();
        for (int i = 0; i < numEntries; ++i) {
            v.visit(ImageVisitor.ImageElement.CACHE_ENTRY_PATH, Text.readString(in));
            v.visit(ImageVisitor.ImageElement.CACHE_ENTRY_REPLICATION, in.readShort());
            v.visit(ImageVisitor.ImageElement.CACHE_ENTRY_POOL_NAME, Text.readString(in));
        }
    }

    private void processDelegationTokens(DataInputStream in, ImageVisitor v) throws IOException {
        v.visit(ImageVisitor.ImageElement.CURRENT_DELEGATION_KEY_ID, in.readInt());
        int numDKeys = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.DELEGATION_KEYS, ImageVisitor.ImageElement.NUM_DELEGATION_KEYS, numDKeys);
        for (int i = 0; i < numDKeys; ++i) {
            DelegationKey key = new DelegationKey();
            key.readFields(in);
            v.visit(ImageVisitor.ImageElement.DELEGATION_KEY, key.toString());
        }
        v.leaveEnclosingElement();
        v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_SEQUENCE_NUMBER, in.readInt());
        int numDTokens = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.DELEGATION_TOKENS, ImageVisitor.ImageElement.NUM_DELEGATION_TOKENS, numDTokens);
        for (int i = 0; i < numDTokens; ++i) {
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            id.readFields(in);
            long expiryTime = in.readLong();
            v.visitEnclosingElement(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER);
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_KIND, id.getKind().toString());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_SEQNO, id.getSequenceNumber());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_OWNER, id.getOwner().toString());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_RENEWER, id.getRenewer().toString());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_REALUSER, id.getRealUser().toString());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_ISSUE_DATE, id.getIssueDate());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_MAX_DATE, id.getMaxDate());
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_EXPIRY_TIME, expiryTime);
            v.visit(ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_MASTER_KEY_ID, id.getMasterKeyId());
            v.leaveEnclosingElement();
        }
        v.leaveEnclosingElement();
    }

    private void processINodesUC(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        int numINUC = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.INODES_UNDER_CONSTRUCTION, ImageVisitor.ImageElement.NUM_INODES_UNDER_CONSTRUCTION, numINUC);
        for (int i = 0; i < numINUC; ++i) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.INODE_UNDER_CONSTRUCTION);
            byte[] name = FSImageSerialization.readBytes(in);
            String n = new String(name, "UTF8");
            v.visit(ImageVisitor.ImageElement.INODE_PATH, n);
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, this.imageVersion)) {
                long inodeId = in.readLong();
                v.visit(ImageVisitor.ImageElement.INODE_ID, inodeId);
            }
            v.visit(ImageVisitor.ImageElement.REPLICATION, in.readShort());
            v.visit(ImageVisitor.ImageElement.MODIFICATION_TIME, this.formatDate(in.readLong()));
            v.visit(ImageVisitor.ImageElement.PREFERRED_BLOCK_SIZE, in.readLong());
            int numBlocks = in.readInt();
            this.processBlocks(in, v, numBlocks, skipBlocks);
            this.processPermission(in, v);
            v.visit(ImageVisitor.ImageElement.CLIENT_NAME, FSImageSerialization.readString(in));
            v.visit(ImageVisitor.ImageElement.CLIENT_MACHINE, FSImageSerialization.readString(in));
            int numLocs = in.readInt();
            for (int j = 0; j < numLocs; ++j) {
                in.readShort();
                in.readLong();
                in.readLong();
                in.readLong();
                in.readInt();
                FSImageSerialization.readString(in);
                FSImageSerialization.readString(in);
                WritableUtils.readEnum(in, DatanodeInfo.AdminStates.class);
            }
            v.leaveEnclosingElement();
        }
        v.leaveEnclosingElement();
    }

    private void processBlocks(DataInputStream in, ImageVisitor v, int numBlocks, boolean skipBlocks) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.BLOCKS, ImageVisitor.ImageElement.NUM_BLOCKS, numBlocks);
        if (numBlocks < 0) {
            v.leaveEnclosingElement();
            return;
        }
        if (skipBlocks) {
            int bytesToSkip = 24 * numBlocks;
            if (in.skipBytes(bytesToSkip) != bytesToSkip) {
                throw new IOException("Error skipping over blocks");
            }
        } else {
            for (int j = 0; j < numBlocks; ++j) {
                v.visitEnclosingElement(ImageVisitor.ImageElement.BLOCK);
                v.visit(ImageVisitor.ImageElement.BLOCK_ID, in.readLong());
                v.visit(ImageVisitor.ImageElement.NUM_BYTES, in.readLong());
                v.visit(ImageVisitor.ImageElement.GENERATION_STAMP, in.readLong());
                v.leaveEnclosingElement();
            }
        }
        v.leaveEnclosingElement();
    }

    private void processPermission(DataInputStream in, ImageVisitor v) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.PERMISSIONS);
        v.visit(ImageVisitor.ImageElement.USER_NAME, Text.readString(in));
        v.visit(ImageVisitor.ImageElement.GROUP_NAME, Text.readString(in));
        FsPermission fsp = new FsPermission(in.readShort());
        v.visit(ImageVisitor.ImageElement.PERMISSION_STRING, fsp.toString());
        v.leaveEnclosingElement();
    }

    private void processCachePoolPermission(DataInputStream in, ImageVisitor v) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.PERMISSIONS);
        v.visit(ImageVisitor.ImageElement.CACHE_POOL_OWNER_NAME, Text.readString(in));
        v.visit(ImageVisitor.ImageElement.CACHE_POOL_GROUP_NAME, Text.readString(in));
        FsPermission fsp = new FsPermission(in.readShort());
        v.visit(ImageVisitor.ImageElement.CACHE_POOL_PERMISSION_STRING, fsp.toString());
        v.leaveEnclosingElement();
    }

    private void processINodes(DataInputStream in, ImageVisitor v, long numInodes, boolean skipBlocks, boolean supportSnapshot) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.INODES, ImageVisitor.ImageElement.NUM_INODES, numInodes);
        if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, this.imageVersion)) {
            if (!supportSnapshot) {
                this.processLocalNameINodes(in, v, numInodes, skipBlocks);
            } else {
                this.processLocalNameINodesWithSnapshot(in, v, skipBlocks);
            }
        } else {
            this.processFullNameINodes(in, v, numInodes, skipBlocks);
        }
        v.leaveEnclosingElement();
    }

    private void processLocalNameINodes(DataInputStream in, ImageVisitor v, long numInodes, boolean skipBlocks) throws IOException {
        this.processINode(in, v, skipBlocks, "", false);
        --numInodes;
        while (numInodes > 0L) {
            numInodes -= (long)this.processDirectory(in, v, skipBlocks);
        }
    }

    private int processDirectory(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        String parentName = FSImageSerialization.readString(in);
        return this.processChildren(in, v, skipBlocks, parentName);
    }

    private void processLocalNameINodesWithSnapshot(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        this.processINode(in, v, skipBlocks, "", false);
        this.processDirectoryWithSnapshot(in, v, skipBlocks);
    }

    private void processDirectoryWithSnapshot(DataInputStream in, ImageVisitor v, boolean skipBlocks) throws IOException {
        long inodeId = in.readLong();
        String dirName = this.dirNodeMap.remove(inodeId);
        Boolean visitedRef = this.subtreeMap.get(inodeId);
        if (visitedRef != null) {
            if (visitedRef.booleanValue()) {
                return;
            }
            this.subtreeMap.put(inodeId, true);
        }
        this.processSnapshots(in, v, dirName);
        this.processChildren(in, v, skipBlocks, dirName);
        this.processDirectoryDiffList(in, v, dirName);
        int numSubTree = in.readInt();
        for (int i = 0; i < numSubTree; ++i) {
            this.processDirectoryWithSnapshot(in, v, skipBlocks);
        }
    }

    private void processSnapshots(DataInputStream in, ImageVisitor v, String rootName) throws IOException {
        int numSnapshots = in.readInt();
        if (numSnapshots >= 0) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOTS, ImageVisitor.ImageElement.NUM_SNAPSHOTS, numSnapshots);
            for (int i = 0; i < numSnapshots; ++i) {
                v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT);
                v.visit(ImageVisitor.ImageElement.SNAPSHOT_ID, in.readInt());
                v.leaveEnclosingElement();
            }
            v.visit(ImageVisitor.ImageElement.SNAPSHOT_QUOTA, in.readInt());
            v.leaveEnclosingElement();
        }
    }

    private void processSnapshot(DataInputStream in, ImageVisitor v) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT);
        v.visit(ImageVisitor.ImageElement.SNAPSHOT_ID, in.readInt());
        v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT_ROOT);
        this.processINode(in, v, true, "", false);
        v.leaveEnclosingElement();
        v.leaveEnclosingElement();
    }

    private void processDirectoryDiffList(DataInputStream in, ImageVisitor v, String currentINodeName) throws IOException {
        int numDirDiff = in.readInt();
        if (numDirDiff >= 0) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT_DIR_DIFFS, ImageVisitor.ImageElement.NUM_SNAPSHOT_DIR_DIFF, numDirDiff);
            for (int i = 0; i < numDirDiff; ++i) {
                this.processDirectoryDiff(in, v, currentINodeName);
            }
            v.leaveEnclosingElement();
        }
    }

    private void processDirectoryDiff(DataInputStream in, ImageVisitor v, String currentINodeName) throws IOException {
        v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT_DIR_DIFF);
        int snapshotId = in.readInt();
        v.visit(ImageVisitor.ImageElement.SNAPSHOT_DIFF_SNAPSHOTID, snapshotId);
        v.visit(ImageVisitor.ImageElement.SNAPSHOT_DIR_DIFF_CHILDREN_SIZE, in.readInt());
        boolean useRoot = in.readBoolean();
        if (!useRoot && in.readBoolean()) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT_INODE_DIRECTORY_ATTRIBUTES);
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.OPTIMIZE_SNAPSHOT_INODES, this.imageVersion)) {
                this.processINodeDirectoryAttributes(in, v, currentINodeName);
            } else {
                this.processINode(in, v, true, currentINodeName, true);
            }
            v.leaveEnclosingElement();
        }
        int createdSize = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT_DIR_DIFF_CREATEDLIST, ImageVisitor.ImageElement.SNAPSHOT_DIR_DIFF_CREATEDLIST_SIZE, createdSize);
        for (int i = 0; i < createdSize; ++i) {
            String createdNode = FSImageSerialization.readString(in);
            v.visit(ImageVisitor.ImageElement.SNAPSHOT_DIR_DIFF_CREATED_INODE, createdNode);
        }
        v.leaveEnclosingElement();
        int deletedSize = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT_DIR_DIFF_DELETEDLIST, ImageVisitor.ImageElement.SNAPSHOT_DIR_DIFF_DELETEDLIST_SIZE, deletedSize);
        for (int i = 0; i < deletedSize; ++i) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT_DIR_DIFF_DELETED_INODE);
            this.processINode(in, v, false, currentINodeName, true);
            v.leaveEnclosingElement();
        }
        v.leaveEnclosingElement();
        v.leaveEnclosingElement();
    }

    private void processINodeDirectoryAttributes(DataInputStream in, ImageVisitor v, String parentName) throws IOException {
        String pathName = this.readINodePath(in, parentName);
        v.visit(ImageVisitor.ImageElement.INODE_PATH, pathName);
        this.processPermission(in, v);
        v.visit(ImageVisitor.ImageElement.MODIFICATION_TIME, this.formatDate(in.readLong()));
        v.visit(ImageVisitor.ImageElement.NS_QUOTA, in.readLong());
        v.visit(ImageVisitor.ImageElement.DS_QUOTA, in.readLong());
    }

    private int processChildren(DataInputStream in, ImageVisitor v, boolean skipBlocks, String parentName) throws IOException {
        int numChildren = in.readInt();
        for (int i = 0; i < numChildren; ++i) {
            this.processINode(in, v, skipBlocks, parentName, false);
        }
        return numChildren;
    }

    private void processFullNameINodes(DataInputStream in, ImageVisitor v, long numInodes, boolean skipBlocks) throws IOException {
        for (long i = 0L; i < numInodes; ++i) {
            this.processINode(in, v, skipBlocks, null, false);
        }
    }

    private String readINodePath(DataInputStream in, String parentName) throws IOException {
        String pathName = FSImageSerialization.readString(in);
        if (parentName != null) {
            pathName = "/" + pathName;
            if (!"/".equals(parentName)) {
                pathName = parentName + pathName;
            }
        }
        return pathName;
    }

    private void processINode(DataInputStream in, ImageVisitor v, boolean skipBlocks, String parentName, boolean isSnapshotCopy) throws IOException {
        boolean supportSnapshot = NameNodeLayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, this.imageVersion);
        boolean supportInodeId = NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, this.imageVersion);
        v.visitEnclosingElement(ImageVisitor.ImageElement.INODE);
        String pathName = this.readINodePath(in, parentName);
        v.visit(ImageVisitor.ImageElement.INODE_PATH, pathName);
        long inodeId = 0L;
        if (supportInodeId) {
            inodeId = in.readLong();
            v.visit(ImageVisitor.ImageElement.INODE_ID, inodeId);
        }
        v.visit(ImageVisitor.ImageElement.REPLICATION, in.readShort());
        v.visit(ImageVisitor.ImageElement.MODIFICATION_TIME, this.formatDate(in.readLong()));
        if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, this.imageVersion)) {
            v.visit(ImageVisitor.ImageElement.ACCESS_TIME, this.formatDate(in.readLong()));
        }
        v.visit(ImageVisitor.ImageElement.BLOCK_SIZE, in.readLong());
        int numBlocks = in.readInt();
        this.processBlocks(in, v, numBlocks, skipBlocks);
        if (numBlocks >= 0) {
            if (supportSnapshot) {
                boolean underConstruction;
                this.subtreeMap.remove(inodeId);
                this.processFileDiffList(in, v, parentName);
                if (isSnapshotCopy && (underConstruction = in.readBoolean())) {
                    v.visit(ImageVisitor.ImageElement.CLIENT_NAME, FSImageSerialization.readString(in));
                    v.visit(ImageVisitor.ImageElement.CLIENT_MACHINE, FSImageSerialization.readString(in));
                }
            }
            this.processPermission(in, v);
        } else if (numBlocks == -1) {
            if (supportSnapshot && supportInodeId) {
                this.dirNodeMap.put(inodeId, pathName);
            }
            v.visit(ImageVisitor.ImageElement.NS_QUOTA, numBlocks == -1 ? in.readLong() : -1L);
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.DISKSPACE_QUOTA, this.imageVersion)) {
                v.visit(ImageVisitor.ImageElement.DS_QUOTA, numBlocks == -1 ? in.readLong() : -1L);
            }
            if (supportSnapshot) {
                boolean snapshottable = in.readBoolean();
                if (!snapshottable) {
                    boolean withSnapshot = in.readBoolean();
                    v.visit(ImageVisitor.ImageElement.IS_WITHSNAPSHOT_DIR, Boolean.toString(withSnapshot));
                } else {
                    v.visit(ImageVisitor.ImageElement.IS_SNAPSHOTTABLE_DIR, Boolean.toString(snapshottable));
                }
            }
            this.processPermission(in, v);
        } else if (numBlocks == -2) {
            v.visit(ImageVisitor.ImageElement.SYMLINK, Text.readString(in));
            this.processPermission(in, v);
        } else if (numBlocks == -3) {
            boolean isWithName = in.readBoolean();
            int snapshotId = in.readInt();
            if (isWithName) {
                v.visit(ImageVisitor.ImageElement.SNAPSHOT_LAST_SNAPSHOT_ID, snapshotId);
            } else {
                v.visit(ImageVisitor.ImageElement.SNAPSHOT_DST_SNAPSHOT_ID, snapshotId);
            }
            boolean firstReferred = in.readBoolean();
            if (firstReferred) {
                this.subtreeMap.put(inodeId, false);
                v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT_REF_INODE);
                this.processINode(in, v, skipBlocks, parentName, isSnapshotCopy);
                v.leaveEnclosingElement();
            } else {
                v.visit(ImageVisitor.ImageElement.SNAPSHOT_REF_INODE_ID, in.readLong());
            }
        }
        v.leaveEnclosingElement();
    }

    private void processINodeFileAttributes(DataInputStream in, ImageVisitor v, String parentName) throws IOException {
        String pathName = this.readINodePath(in, parentName);
        v.visit(ImageVisitor.ImageElement.INODE_PATH, pathName);
        this.processPermission(in, v);
        v.visit(ImageVisitor.ImageElement.MODIFICATION_TIME, this.formatDate(in.readLong()));
        if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, this.imageVersion)) {
            v.visit(ImageVisitor.ImageElement.ACCESS_TIME, this.formatDate(in.readLong()));
        }
        v.visit(ImageVisitor.ImageElement.REPLICATION, in.readShort());
        v.visit(ImageVisitor.ImageElement.BLOCK_SIZE, in.readLong());
    }

    private void processFileDiffList(DataInputStream in, ImageVisitor v, String currentINodeName) throws IOException {
        int size = in.readInt();
        if (size >= 0) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT_FILE_DIFFS, ImageVisitor.ImageElement.NUM_SNAPSHOT_FILE_DIFF, size);
            for (int i = 0; i < size; ++i) {
                this.processFileDiff(in, v, currentINodeName);
            }
            v.leaveEnclosingElement();
        }
    }

    private void processFileDiff(DataInputStream in, ImageVisitor v, String currentINodeName) throws IOException {
        int snapshotId = in.readInt();
        v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT_FILE_DIFF, ImageVisitor.ImageElement.SNAPSHOT_DIFF_SNAPSHOTID, snapshotId);
        v.visit(ImageVisitor.ImageElement.SNAPSHOT_FILE_SIZE, in.readLong());
        if (in.readBoolean()) {
            v.visitEnclosingElement(ImageVisitor.ImageElement.SNAPSHOT_INODE_FILE_ATTRIBUTES);
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.OPTIMIZE_SNAPSHOT_INODES, this.imageVersion)) {
                this.processINodeFileAttributes(in, v, currentINodeName);
            } else {
                this.processINode(in, v, true, currentINodeName, true);
            }
            v.leaveEnclosingElement();
        }
        v.leaveEnclosingElement();
    }

    private String formatDate(long date) {
        return this.dateFormat.format(new Date(date));
    }
}

