/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Charsets;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.util.StringUtils;

class FSImageHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    public static final Log LOG = LogFactory.getLog(FSImageHandler.class);
    private final FSImageLoader image;
    private final ChannelGroup activeChannels;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.activeChannels.add((Object)ctx.channel());
    }

    FSImageHandler(FSImageLoader image, ChannelGroup activeChannels) throws IOException {
        this.image = image;
        this.activeChannels = activeChannels;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        String content;
        if (request.getMethod() != HttpMethod.GET) {
            DefaultHttpResponse resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
            resp.headers().set("Connection", (Object)"close");
            ctx.write((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
        String op = FSImageHandler.getOp(decoder);
        String path = FSImageHandler.getPath(decoder);
        switch (op) {
            case "GETFILESTATUS": {
                content = this.image.getFileStatus(path);
                break;
            }
            case "LISTSTATUS": {
                content = this.image.listStatus(path);
                break;
            }
            case "GETACLSTATUS": {
                content = this.image.getAclStatus(path);
                break;
            }
            case "GETXATTRS": {
                List<String> names = FSImageHandler.getXattrNames(decoder);
                String encoder = FSImageHandler.getEncoder(decoder);
                content = this.image.getXAttrs(path, names, encoder);
                break;
            }
            case "LISTXATTRS": {
                content = this.image.listXAttrs(path);
                break;
            }
            case "GETCONTENTSUMMARY": {
                content = this.image.getContentSummary(path);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for webhdfs parameter \"op\"");
            }
        }
        LOG.info("op=" + op + " target=" + path);
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])content.getBytes(Charsets.UTF_8)));
        resp.headers().set("Content-Type", (Object)"application/json; charset=utf-8");
        resp.headers().set("Content-Length", (Object)resp.content().readableBytes());
        resp.headers().set("Connection", (Object)"close");
        ctx.write((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Exception e = cause instanceof Exception ? (Exception)cause : new Exception(cause);
        String output = JsonUtil.toJsonString(e);
        ByteBuf content = Unpooled.wrappedBuffer((byte[])output.getBytes(Charsets.UTF_8));
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, content);
        resp.headers().set("Content-Type", (Object)"application/json; charset=utf-8");
        if (e instanceof IllegalArgumentException) {
            resp.setStatus(HttpResponseStatus.BAD_REQUEST);
        } else if (e instanceof FileNotFoundException) {
            resp.setStatus(HttpResponseStatus.NOT_FOUND);
        } else if (e instanceof IOException) {
            resp.setStatus(HttpResponseStatus.FORBIDDEN);
        }
        resp.headers().set("Content-Length", (Object)resp.content().readableBytes());
        resp.headers().set("Connection", (Object)"close");
        ctx.write((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static String getOp(QueryStringDecoder decoder) {
        Map parameters = decoder.parameters();
        return parameters.containsKey("op") ? StringUtils.toUpperCase((String)((List)parameters.get("op")).get(0)) : null;
    }

    private static List<String> getXattrNames(QueryStringDecoder decoder) {
        Map parameters = decoder.parameters();
        return (List)parameters.get("xattr.name");
    }

    private static String getEncoder(QueryStringDecoder decoder) {
        Map parameters = decoder.parameters();
        return parameters.containsKey("encoding") ? (String)((List)parameters.get("encoding")).get(0) : null;
    }

    private static String getPath(QueryStringDecoder decoder) throws FileNotFoundException {
        String path = decoder.path();
        if (path.startsWith("/webhdfs/v1")) {
            return path.substring(WebHdfsHandler.WEBHDFS_PREFIX_LENGTH);
        }
        throw new FileNotFoundException("Path: " + path + " should " + "start with " + "/webhdfs/v1");
    }
}

