/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.XAttr;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.SerialNumberMap;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.XAttrFeature;

@InterfaceAudience.Private
public class XAttrStorage {
    private static final SerialNumberMap<String> NAME_MAP = new SerialNumberMap();

    public static int getNameSerialNumber(String name) {
        return NAME_MAP.get(name);
    }

    public static String getName(int n) {
        return NAME_MAP.get(n);
    }

    public static XAttr readINodeXAttrByPrefixedName(INodesInPath iip, String prefixedName) {
        XAttrFeature f = iip.getLastINode().getXAttrFeature(iip.getPathSnapshotId());
        return f == null ? null : f.getXAttr(prefixedName);
    }

    public static List<XAttr> readINodeXAttrs(INodeAttributes inodeAttr) {
        XAttrFeature f = inodeAttr.getXAttrFeature();
        return f == null ? new ArrayList(0) : f.getXAttrs();
    }

    public static void updateINodeXAttrs(INode inode, List<XAttr> xAttrs, int snapshotId) throws QuotaExceededException {
        if (inode.getXAttrFeature() != null) {
            inode.removeXAttrFeature(snapshotId);
        }
        if (xAttrs == null || xAttrs.isEmpty()) {
            return;
        }
        inode.addXAttrFeature(new XAttrFeature(xAttrs), snapshotId);
    }
}

