/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Charsets;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.Token;

public class RenewDelegationTokenServlet
extends DfsServlet {
    private static final Log LOG = LogFactory.getLog(RenewDelegationTokenServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserGroupInformation ugi;
        ServletContext context = this.getServletContext();
        Configuration conf = NameNodeHttpServer.getConfFromContext(context);
        try {
            ugi = this.getUGI(req, conf);
        }
        catch (IOException ioe) {
            LOG.info("Request for token received with no authentication from " + req.getRemoteAddr(), ioe);
            resp.sendError(403, "Unable to identify or authenticate user");
            return;
        }
        final NameNode nn = NameNodeHttpServer.getNameNodeFromContext(context);
        String tokenString = req.getParameter("token");
        if (tokenString == null) {
            resp.sendError(300, "Token to renew not specified");
        }
        final Token token = new Token();
        token.decodeFromUrlString(tokenString);
        try {
            long result = ugi.doAs(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws Exception {
                    return nn.getRpcServer().renewDelegationToken(token);
                }
            });
            PrintWriter os = new PrintWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream(), Charsets.UTF_8));
            os.println(result);
            os.close();
        }
        catch (Exception e) {
            String exceptionClass = e.getClass().getName();
            String exceptionMsg = e.getLocalizedMessage();
            String strException = exceptionClass + ";" + exceptionMsg;
            LOG.info("Exception while renewing token. Re-throwing. s=" + strException, e);
            resp.sendError(500, strException);
        }
    }
}

