/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum FSEditLogOpCodes {
    OP_ADD(0, FSEditLogOp.AddOp.class),
    OP_RENAME_OLD(1, FSEditLogOp.RenameOldOp.class),
    OP_DELETE(2, FSEditLogOp.DeleteOp.class),
    OP_MKDIR(3, FSEditLogOp.MkdirOp.class),
    OP_SET_REPLICATION(4, FSEditLogOp.SetReplicationOp.class),
    OP_DATANODE_ADD(5),
    OP_DATANODE_REMOVE(6),
    OP_SET_PERMISSIONS(7, FSEditLogOp.SetPermissionsOp.class),
    OP_SET_OWNER(8, FSEditLogOp.SetOwnerOp.class),
    OP_CLOSE(9, FSEditLogOp.CloseOp.class),
    OP_SET_GENSTAMP_V1(10, FSEditLogOp.SetGenstampV1Op.class),
    OP_SET_NS_QUOTA(11, FSEditLogOp.SetNSQuotaOp.class),
    OP_CLEAR_NS_QUOTA(12, FSEditLogOp.ClearNSQuotaOp.class),
    OP_TIMES(13, FSEditLogOp.TimesOp.class),
    OP_SET_QUOTA(14, FSEditLogOp.SetQuotaOp.class),
    OP_RENAME(15, FSEditLogOp.RenameOp.class),
    OP_CONCAT_DELETE(16, FSEditLogOp.ConcatDeleteOp.class),
    OP_SYMLINK(17, FSEditLogOp.SymlinkOp.class),
    OP_GET_DELEGATION_TOKEN(18, FSEditLogOp.GetDelegationTokenOp.class),
    OP_RENEW_DELEGATION_TOKEN(19, FSEditLogOp.RenewDelegationTokenOp.class),
    OP_CANCEL_DELEGATION_TOKEN(20, FSEditLogOp.CancelDelegationTokenOp.class),
    OP_UPDATE_MASTER_KEY(21, FSEditLogOp.UpdateMasterKeyOp.class),
    OP_REASSIGN_LEASE(22, FSEditLogOp.ReassignLeaseOp.class),
    OP_END_LOG_SEGMENT(23, FSEditLogOp.EndLogSegmentOp.class),
    OP_START_LOG_SEGMENT(24, FSEditLogOp.StartLogSegmentOp.class),
    OP_UPDATE_BLOCKS(25, FSEditLogOp.UpdateBlocksOp.class),
    OP_CREATE_SNAPSHOT(26, FSEditLogOp.CreateSnapshotOp.class),
    OP_DELETE_SNAPSHOT(27, FSEditLogOp.DeleteSnapshotOp.class),
    OP_RENAME_SNAPSHOT(28, FSEditLogOp.RenameSnapshotOp.class),
    OP_ALLOW_SNAPSHOT(29, FSEditLogOp.AllowSnapshotOp.class),
    OP_DISALLOW_SNAPSHOT(30, FSEditLogOp.DisallowSnapshotOp.class),
    OP_SET_GENSTAMP_V2(31, FSEditLogOp.SetGenstampV2Op.class),
    OP_ALLOCATE_BLOCK_ID(32, FSEditLogOp.AllocateBlockIdOp.class),
    OP_ADD_BLOCK(33, FSEditLogOp.AddBlockOp.class),
    OP_ADD_CACHE_DIRECTIVE(34, FSEditLogOp.AddCacheDirectiveInfoOp.class),
    OP_REMOVE_CACHE_DIRECTIVE(35, FSEditLogOp.RemoveCacheDirectiveInfoOp.class),
    OP_ADD_CACHE_POOL(36, FSEditLogOp.AddCachePoolOp.class),
    OP_MODIFY_CACHE_POOL(37, FSEditLogOp.ModifyCachePoolOp.class),
    OP_REMOVE_CACHE_POOL(38, FSEditLogOp.RemoveCachePoolOp.class),
    OP_MODIFY_CACHE_DIRECTIVE(39, FSEditLogOp.ModifyCacheDirectiveInfoOp.class),
    OP_SET_ACL(40, FSEditLogOp.SetAclOp.class),
    OP_ROLLING_UPGRADE_START(41, FSEditLogOp.RollingUpgradeStartOp.class),
    OP_ROLLING_UPGRADE_FINALIZE(42, FSEditLogOp.RollingUpgradeFinalizeOp.class),
    OP_SET_XATTR(43, FSEditLogOp.SetXAttrOp.class),
    OP_REMOVE_XATTR(44, FSEditLogOp.RemoveXAttrOp.class),
    OP_SET_STORAGE_POLICY(45, FSEditLogOp.SetStoragePolicyOp.class),
    OP_TRUNCATE(46, FSEditLogOp.TruncateOp.class),
    OP_APPEND(47, FSEditLogOp.AppendOp.class),
    OP_SET_QUOTA_BY_STORAGETYPE(48, FSEditLogOp.SetQuotaByStorageTypeOp.class),
    OP_INVALID(-1);

    private final byte opCode;
    private final Class<? extends FSEditLogOp> opClass;
    private static final FSEditLogOpCodes[] VALUES;

    private FSEditLogOpCodes(byte opCode) {
        this(opCode, null);
    }

    private FSEditLogOpCodes(byte opCode, Class<? extends FSEditLogOp> opClass) {
        this.opCode = opCode;
        this.opClass = opClass;
    }

    public byte getOpCode() {
        return this.opCode;
    }

    public Class<? extends FSEditLogOp> getOpClass() {
        return this.opClass;
    }

    public static FSEditLogOpCodes fromByte(byte opCode) {
        if (opCode >= 0 && opCode < VALUES.length) {
            return VALUES[opCode];
        }
        return opCode == -1 ? OP_INVALID : null;
    }

    static {
        byte max = 0;
        for (FSEditLogOpCodes code : FSEditLogOpCodes.values()) {
            if (code.getOpCode() <= max) continue;
            max = code.getOpCode();
        }
        VALUES = new FSEditLogOpCodes[max + 1];
        for (FSEditLogOpCodes code : FSEditLogOpCodes.values()) {
            if (code.getOpCode() < 0) continue;
            FSEditLogOpCodes.VALUES[code.getOpCode()] = code;
        }
    }
}

