/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.INodeReference;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContentSummaryComputationContext {
    private FSDirectory dir = null;
    private FSNamesystem fsn = null;
    private BlockStoragePolicySuite bsps = null;
    private ContentCounts counts = null;
    private ContentCounts snapshotCounts = null;
    private long nextCountLimit = 0L;
    private long limitPerRun = 0L;
    private long yieldCount = 0L;
    private long sleepMilliSec = 0L;
    private int sleepNanoSec = 0;
    private Set<INode> includedNodes = new HashSet<INode>();
    private Set<INode> deletedSnapshottedNodes = new HashSet<INode>();

    public ContentSummaryComputationContext(FSDirectory dir, FSNamesystem fsn, long limitPerRun, long sleepMicroSec) {
        this.dir = dir;
        this.fsn = fsn;
        this.limitPerRun = limitPerRun;
        this.nextCountLimit = limitPerRun;
        this.setCounts(new ContentCounts.Builder().build());
        this.setSnapshotCounts(new ContentCounts.Builder().build());
        this.sleepMilliSec = sleepMicroSec / 1000L;
        this.sleepNanoSec = (int)(sleepMicroSec % 1000L * 1000L);
    }

    public ContentSummaryComputationContext(BlockStoragePolicySuite bsps) {
        this(null, null, 0L, 1000L);
        this.bsps = bsps;
    }

    public long getYieldCount() {
        return this.yieldCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean yield() {
        if (this.limitPerRun <= 0L || this.dir == null || this.fsn == null) {
            return false;
        }
        ContentCounts counts = this.getCounts();
        long currentCount = counts.getFileCount() + counts.getSymlinkCount() + counts.getDirectoryCount() + counts.getSnapshotableDirectoryCount();
        if (currentCount <= this.nextCountLimit) {
            return false;
        }
        this.nextCountLimit = currentCount + this.limitPerRun;
        boolean hadDirReadLock = this.dir.hasReadLock();
        boolean hadDirWriteLock = this.dir.hasWriteLock();
        boolean hadFsnReadLock = this.fsn.hasReadLock();
        boolean hadFsnWriteLock = this.fsn.hasWriteLock();
        if (!hadDirReadLock || !hadFsnReadLock || hadDirWriteLock || hadFsnWriteLock || this.dir.getReadHoldCount() != 1 || this.fsn.getReadHoldCount() != 1) {
            return false;
        }
        this.dir.readUnlock();
        this.fsn.readUnlock("contentSummary");
        try {
            Thread.sleep(this.sleepMilliSec, this.sleepNanoSec);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.fsn.readLock();
            this.dir.readLock();
        }
        ++this.yieldCount;
        return true;
    }

    public synchronized ContentCounts getCounts() {
        return this.counts;
    }

    private synchronized void setCounts(ContentCounts counts) {
        this.counts = counts;
    }

    public ContentCounts getSnapshotCounts() {
        return this.snapshotCounts;
    }

    private void setSnapshotCounts(ContentCounts snapshotCounts) {
        this.snapshotCounts = snapshotCounts;
    }

    public BlockStoragePolicySuite getBlockStoragePolicySuite() {
        Preconditions.checkState(this.bsps != null || this.fsn != null, "BlockStoragePolicySuite must be either initialized or available via FSNameSystem");
        return this.bsps != null ? this.bsps : this.fsn.getBlockManager().getStoragePolicySuite();
    }

    private INode resolveINodeReference(INode node) {
        if (node.isReference() && node instanceof INodeReference) {
            return ((INodeReference)node).getReferredINode();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeIncluded(INode node) {
        INode resolvedNode = this.resolveINodeReference(node);
        Set<INode> set = this.includedNodes;
        synchronized (set) {
            if (!this.includedNodes.contains(resolvedNode)) {
                this.includedNodes.add(resolvedNode);
                return false;
            }
        }
        return true;
    }

    public void reportDeletedSnapshottedNode(INode node) {
        this.deletedSnapshottedNodes.add(node);
    }

    public synchronized void tallyDeletedSnapshottedINodes() {
        ContentCounts originalCounts = this.getCounts();
        this.setCounts(new ContentCounts.Builder().build());
        for (INode node : this.deletedSnapshottedNodes) {
            if (this.nodeIncluded(node)) continue;
            node.computeContentSummary(0x7FFFFFFE, this);
        }
        originalCounts.addContents(this.getCounts());
        this.snapshotCounts.addContents(this.getCounts());
        this.setCounts(originalCounts);
    }
}

