/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.security.token.delegation;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.collections.map.LRUMap;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;

@InterfaceAudience.Private
public class DelegationTokenIdentifier
extends AbstractDelegationTokenIdentifier {
    public static final Text HDFS_DELEGATION_KIND = new Text("HDFS_DELEGATION_TOKEN");
    private static Map<TokenIdentifier, UserGroupInformation> ugiCache = Collections.synchronizedMap(new LRUMap(64));

    @VisibleForTesting
    public void clearCache() {
        ugiCache.clear();
    }

    public DelegationTokenIdentifier() {
    }

    public DelegationTokenIdentifier(Text owner, Text renewer, Text realUser) {
        super(owner, renewer, realUser);
    }

    @Override
    public Text getKind() {
        return HDFS_DELEGATION_KIND;
    }

    @Override
    public UserGroupInformation getUser() {
        UserGroupInformation ugi = ugiCache.get(this);
        if (ugi == null) {
            ugi = super.getUser();
            ugiCache.put(this, ugi);
        }
        return ugi;
    }

    @Override
    public String toString() {
        return this.getKind() + " token " + this.getSequenceNumber() + " for " + this.getUser().getShortUserName();
    }

    public static String stringifyToken(Token<?> token) throws IOException {
        DelegationTokenIdentifier ident = new DelegationTokenIdentifier();
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        ident.readFields(in);
        if (token.getService().getLength() > 0) {
            return ident + " on " + token.getService();
        }
        return ident.toString();
    }

    public static class SWebHdfsDelegationTokenIdentifier
    extends WebHdfsDelegationTokenIdentifier {
        @Override
        public Text getKind() {
            return WebHdfsConstants.SWEBHDFS_TOKEN_KIND;
        }
    }

    public static class WebHdfsDelegationTokenIdentifier
    extends DelegationTokenIdentifier {
        @Override
        public Text getKind() {
            return WebHdfsConstants.WEBHDFS_TOKEN_KIND;
        }
    }
}

