/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.qjournal.server;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.fs.s3hadoop.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileUtil;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.common.StorageErrorReporter;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;

class JNStorage
extends Storage {
    private final FileJournalManager fjm;
    private final Storage.StorageDirectory sd;
    private Storage.StorageState state;
    private static final List<Pattern> CURRENT_DIR_PURGE_REGEXES = ImmutableList.of(Pattern.compile("edits_\\d+-(\\d+)"), Pattern.compile("edits_inprogress_(\\d+)(?:\\..*)?"));
    private static final List<Pattern> PAXOS_DIR_PURGE_REGEXES = ImmutableList.of(Pattern.compile("(\\d+)"));

    protected JNStorage(Configuration conf, File logDir, HdfsServerConstants.StartupOption startOpt, StorageErrorReporter errorReporter) throws IOException {
        super(HdfsServerConstants.NodeType.JOURNAL_NODE);
        this.sd = new Storage.StorageDirectory(logDir);
        this.addStorageDir(this.sd);
        this.fjm = new FileJournalManager(conf, this.sd, errorReporter);
        this.analyzeAndRecoverStorage(startOpt);
    }

    FileJournalManager getJournalManager() {
        return this.fjm;
    }

    @Override
    public boolean isPreUpgradableLayout(Storage.StorageDirectory sd) throws IOException {
        return false;
    }

    File findFinalizedEditsFile(long startTxId, long endTxId) throws IOException {
        File ret = new File(this.sd.getCurrentDir(), NNStorage.getFinalizedEditsFileName(startTxId, endTxId));
        if (!ret.exists()) {
            throw new IOException("No edits file for range " + startTxId + "-" + endTxId);
        }
        return ret;
    }

    File getInProgressEditLog(long startTxId) {
        return new File(this.sd.getCurrentDir(), NNStorage.getInProgressEditsFileName(startTxId));
    }

    File getSyncLogTemporaryFile(long segmentTxId, long epoch) {
        String name = NNStorage.getInProgressEditsFileName(segmentTxId) + ".epoch=" + epoch;
        return new File(this.sd.getCurrentDir(), name);
    }

    File getPaxosFile(long segmentTxId) {
        return new File(this.getPaxosDir(), String.valueOf(segmentTxId));
    }

    File getPaxosDir() {
        return new File(this.sd.getCurrentDir(), "paxos");
    }

    File getRoot() {
        return this.sd.getRoot();
    }

    void purgeDataOlderThan(long minTxIdToKeep) throws IOException {
        JNStorage.purgeMatching(this.sd.getCurrentDir(), CURRENT_DIR_PURGE_REGEXES, minTxIdToKeep);
        JNStorage.purgeMatching(this.getPaxosDir(), PAXOS_DIR_PURGE_REGEXES, minTxIdToKeep);
    }

    private static void purgeMatching(File dir, List<Pattern> patterns, long minTxIdToKeep) throws IOException {
        block0: for (File f : FileUtil.listFiles(dir)) {
            if (!f.isFile()) continue;
            for (Pattern p : patterns) {
                long txid;
                Matcher matcher = p.matcher(f.getName());
                if (!matcher.matches() || (txid = Long.parseLong(matcher.group(1))) >= minTxIdToKeep) continue;
                LOG.info("Purging no-longer needed file " + txid);
                if (f.delete()) continue block0;
                LOG.warn("Unable to delete no-longer-needed data " + f);
                continue block0;
            }
        }
    }

    void format(NamespaceInfo nsInfo) throws IOException {
        this.setStorageInfo(nsInfo);
        LOG.info("Formatting journal " + this.sd + " with nsid: " + this.getNamespaceID());
        this.unlockAll();
        this.sd.clearDirectory();
        this.writeProperties(this.sd);
        this.createPaxosDir();
        this.analyzeStorage();
    }

    void createPaxosDir() throws IOException {
        if (!this.getPaxosDir().mkdirs()) {
            throw new IOException("Could not create paxos dir: " + this.getPaxosDir());
        }
    }

    void analyzeStorage() throws IOException {
        this.state = this.sd.analyzeStorage(HdfsServerConstants.StartupOption.REGULAR, this);
        if (this.state == Storage.StorageState.NORMAL) {
            this.readProperties(this.sd);
        }
    }

    @Override
    protected void setLayoutVersion(Properties props, Storage.StorageDirectory sd) throws IncorrectVersionException, InconsistentFSStateException {
        int lv;
        this.layoutVersion = lv = Integer.parseInt(JNStorage.getProperty(props, sd, "layoutVersion"));
    }

    void analyzeAndRecoverStorage(HdfsServerConstants.StartupOption startOpt) throws IOException {
        boolean needRecover;
        this.state = this.sd.analyzeStorage(startOpt, this);
        boolean bl = needRecover = this.state != Storage.StorageState.NORMAL && this.state != Storage.StorageState.NON_EXISTENT && this.state != Storage.StorageState.NOT_FORMATTED;
        if (this.state == Storage.StorageState.NORMAL && startOpt != HdfsServerConstants.StartupOption.ROLLBACK) {
            this.readProperties(this.sd);
        } else if (needRecover) {
            this.sd.doRecover(this.state);
        }
    }

    void checkConsistentNamespace(NamespaceInfo nsInfo) throws IOException {
        if (nsInfo.getNamespaceID() != this.getNamespaceID()) {
            throw new IOException("Incompatible namespaceID for journal " + this.sd + ": NameNode has nsId " + nsInfo.getNamespaceID() + " but storage has nsId " + this.getNamespaceID());
        }
        if (!nsInfo.getClusterID().equals(this.getClusterID())) {
            throw new IOException("Incompatible clusterID for journal " + this.sd + ": NameNode has clusterId '" + nsInfo.getClusterID() + "' but storage has clusterId '" + this.getClusterID() + "'");
        }
    }

    public void close() throws IOException {
        LOG.info("Closing journal storage for " + this.sd);
        this.unlockAll();
    }

    public boolean isFormatted() {
        return this.state == Storage.StorageState.NORMAL;
    }
}

