/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.core.TraceScope;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class EncryptionZoneIterator
extends BatchedRemoteIterator<Long, EncryptionZone> {
    private final ClientProtocol namenode;
    private final Tracer tracer;

    public EncryptionZoneIterator(ClientProtocol namenode, Tracer tracer) {
        super(0L);
        this.namenode = namenode;
        this.tracer = tracer;
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> makeRequest(Long prevId) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("listEncryptionZones");){
            BatchedRemoteIterator.BatchedEntries<EncryptionZone> batchedEntries = this.namenode.listEncryptionZones(prevId);
            return batchedEntries;
        }
    }

    @Override
    public Long elementToPrevKey(EncryptionZone entry) {
        return entry.getId();
    }
}

