/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.s3native;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.s3.S3Credentials;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.s3.S3Exception;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.s3native.FileMetadata;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.s3native.PartialListing;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.io.IOUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.security.AccessControlException;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.impl.rest.HttpException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.MultipartUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Jets3tNativeFileSystemStore
implements NativeFileSystemStore {
    private S3Service s3Service;
    private S3Bucket bucket;
    private long multipartBlockSize;
    private boolean multipartEnabled;
    private long multipartCopyBlockSize;
    static final long MAX_PART_SIZE = 0x140000000L;
    private String serverSideEncryptionAlgorithm;
    public static final Logger LOG = LoggerFactory.getLogger(Jets3tNativeFileSystemStore.class);

    Jets3tNativeFileSystemStore() {
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        S3Credentials s3Credentials = new S3Credentials();
        s3Credentials.initialize(uri, conf);
        try {
            AWSCredentials awsCredentials = new AWSCredentials(s3Credentials.getAccessKey(), s3Credentials.getSecretAccessKey());
            this.s3Service = new RestS3Service((ProviderCredentials)awsCredentials);
        }
        catch (S3ServiceException e) {
            this.handleException((Exception)((Object)e));
        }
        this.multipartEnabled = conf.getBoolean("fs.s3n.multipart.uploads.enabled", false);
        this.multipartBlockSize = Math.min(conf.getLong("fs.s3n.multipart.uploads.block.size", 0x4000000L), 0x140000000L);
        this.multipartCopyBlockSize = Math.min(conf.getLong("fs.s3n.multipart.copy.block.size", 0x140000000L), 0x140000000L);
        this.serverSideEncryptionAlgorithm = conf.get("fs.s3n.server-side-encryption-algorithm");
        this.bucket = new S3Bucket(uri.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeFile(String key, File file, byte[] md5Hash) throws IOException {
        if (this.multipartEnabled && file.length() >= this.multipartBlockSize) {
            this.storeLargeFile(key, file, md5Hash);
            return;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            S3Object object = new S3Object(key);
            object.setDataInputStream((InputStream)in);
            object.setContentType("binary/octet-stream");
            object.setContentLength(file.length());
            object.setServerSideEncryptionAlgorithm(this.serverSideEncryptionAlgorithm);
            if (md5Hash != null) {
                object.setMd5Hash(md5Hash);
            }
            this.s3Service.putObject(this.bucket, object);
        }
        catch (ServiceException e) {
            try {
                this.handleException((Exception)((Object)e), key);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(in);
                throw throwable;
            }
            IOUtils.closeStream(in);
        }
        IOUtils.closeStream(in);
    }

    public void storeLargeFile(String key, File file, byte[] md5Hash) throws IOException {
        S3Object object = new S3Object(key);
        object.setDataInputFile(file);
        object.setContentType("binary/octet-stream");
        object.setContentLength(file.length());
        object.setServerSideEncryptionAlgorithm(this.serverSideEncryptionAlgorithm);
        if (md5Hash != null) {
            object.setMd5Hash(md5Hash);
        }
        ArrayList<S3Object> objectsToUploadAsMultipart = new ArrayList<S3Object>();
        objectsToUploadAsMultipart.add(object);
        MultipartUtils mpUtils = new MultipartUtils(this.multipartBlockSize);
        try {
            mpUtils.uploadObjects(this.bucket.getName(), this.s3Service, objectsToUploadAsMultipart, null);
        }
        catch (Exception e) {
            this.handleException(e, key);
        }
    }

    @Override
    public void storeEmptyFile(String key) throws IOException {
        try {
            S3Object object = new S3Object(key);
            object.setDataInputStream((InputStream)new ByteArrayInputStream(new byte[0]));
            object.setContentType("binary/octet-stream");
            object.setContentLength(0L);
            object.setServerSideEncryptionAlgorithm(this.serverSideEncryptionAlgorithm);
            this.s3Service.putObject(this.bucket, object);
        }
        catch (ServiceException e) {
            this.handleException((Exception)((Object)e), key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileMetadata retrieveMetadata(String key) throws IOException {
        StorageObject object = null;
        try {
            LOG.debug("Getting metadata for key: {} from bucket: {}", (Object)key, (Object)this.bucket.getName());
            object = this.s3Service.getObjectDetails(this.bucket.getName(), key);
            FileMetadata fileMetadata = new FileMetadata(key, object.getContentLength(), object.getLastModifiedDate().getTime());
            return fileMetadata;
        }
        catch (ServiceException e) {
            try {
                this.handleException((Exception)((Object)e), key);
                FileMetadata fileMetadata = null;
                return fileMetadata;
            }
            catch (FileNotFoundException fnfe) {
                FileMetadata fileMetadata = null;
                return fileMetadata;
            }
        }
        finally {
            if (object != null) {
                object.closeDataInputStream();
            }
        }
    }

    @Override
    public InputStream retrieve(String key) throws IOException {
        try {
            LOG.debug("Getting key: {} from bucket: {}", (Object)key, (Object)this.bucket.getName());
            S3Object object = this.s3Service.getObject(this.bucket.getName(), key);
            return object.getDataInputStream();
        }
        catch (ServiceException e) {
            this.handleException((Exception)((Object)e), key);
            return null;
        }
    }

    @Override
    public InputStream retrieve(String key, long byteRangeStart) throws IOException {
        try {
            LOG.debug("Getting key: {} from bucket: {} with byteRangeStart: {}", new Object[]{key, this.bucket.getName(), byteRangeStart});
            S3Object object = this.s3Service.getObject(this.bucket, key, null, null, null, null, Long.valueOf(byteRangeStart), null);
            return object.getDataInputStream();
        }
        catch (ServiceException e) {
            this.handleException((Exception)((Object)e), key);
            return null;
        }
    }

    @Override
    public PartialListing list(String prefix, int maxListingLength) throws IOException {
        return this.list(prefix, maxListingLength, null, false);
    }

    @Override
    public PartialListing list(String prefix, int maxListingLength, String priorLastKey, boolean recurse) throws IOException {
        return this.list(prefix, recurse ? null : "/", maxListingLength, priorLastKey);
    }

    private PartialListing list(String prefix, String delimiter, int maxListingLength, String priorLastKey) throws IOException {
        try {
            if (!prefix.isEmpty() && !prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            StorageObjectsChunk chunk = this.s3Service.listObjectsChunked(this.bucket.getName(), prefix, delimiter, (long)maxListingLength, priorLastKey);
            FileMetadata[] fileMetadata = new FileMetadata[chunk.getObjects().length];
            for (int i = 0; i < fileMetadata.length; ++i) {
                StorageObject object = chunk.getObjects()[i];
                fileMetadata[i] = new FileMetadata(object.getKey(), object.getContentLength(), object.getLastModifiedDate().getTime());
            }
            return new PartialListing(chunk.getPriorLastKey(), fileMetadata, chunk.getCommonPrefixes());
        }
        catch (ServiceException e) {
            this.handleException((Exception)((Object)e), prefix);
            return null;
        }
    }

    @Override
    public void delete(String key) throws IOException {
        try {
            LOG.debug("Deleting key: {} from bucket: {}", (Object)key, (Object)this.bucket.getName());
            this.s3Service.deleteObject(this.bucket, key);
        }
        catch (ServiceException e) {
            this.handleException((Exception)((Object)e), key);
        }
    }

    public void rename(String srcKey, String dstKey) throws IOException {
        try {
            this.s3Service.renameObject(this.bucket.getName(), srcKey, (StorageObject)new S3Object(dstKey));
        }
        catch (ServiceException e) {
            this.handleException((Exception)((Object)e), srcKey);
        }
    }

    @Override
    public void copy(String srcKey, String dstKey) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Copying srcKey: " + srcKey + "to dstKey: " + dstKey + "in bucket: " + this.bucket.getName());
            }
            if (this.multipartEnabled) {
                S3Object object = this.s3Service.getObjectDetails(this.bucket, srcKey, null, null, null, null);
                if (this.multipartCopyBlockSize > 0L && object.getContentLength() > this.multipartCopyBlockSize) {
                    this.copyLargeFile(object, dstKey);
                    return;
                }
            }
            S3Object dstObject = new S3Object(dstKey);
            dstObject.setServerSideEncryptionAlgorithm(this.serverSideEncryptionAlgorithm);
            this.s3Service.copyObject(this.bucket.getName(), srcKey, this.bucket.getName(), (StorageObject)dstObject, false);
        }
        catch (ServiceException e) {
            this.handleException((Exception)((Object)e), srcKey);
        }
    }

    public void copyLargeFile(S3Object srcObject, String dstKey) throws IOException {
        try {
            long partCount = srcObject.getContentLength() / this.multipartCopyBlockSize + (long)(srcObject.getContentLength() % this.multipartCopyBlockSize > 0L ? 1 : 0);
            MultipartUpload multipartUpload = this.s3Service.multipartStartUpload(this.bucket.getName(), dstKey, srcObject.getMetadataMap());
            ArrayList<MultipartPart> listedParts = new ArrayList<MultipartPart>();
            int i = 0;
            while ((long)i < partCount) {
                long byteLength;
                long byteRangeStart = (long)i * this.multipartCopyBlockSize;
                if ((long)i < partCount - 1L) {
                    byteLength = this.multipartCopyBlockSize;
                } else {
                    byteLength = srcObject.getContentLength() % this.multipartCopyBlockSize;
                    if (byteLength == 0L) {
                        byteLength = this.multipartCopyBlockSize;
                    }
                }
                MultipartPart copiedPart = this.s3Service.multipartUploadPartCopy(multipartUpload, Integer.valueOf(i + 1), this.bucket.getName(), srcObject.getKey(), null, null, null, null, Long.valueOf(byteRangeStart), Long.valueOf(byteRangeStart + byteLength - 1L), null);
                listedParts.add(copiedPart);
                ++i;
            }
            Collections.reverse(listedParts);
            this.s3Service.multipartCompleteUpload(multipartUpload, listedParts);
        }
        catch (ServiceException e) {
            this.handleException((Exception)((Object)e), srcObject.getKey());
        }
    }

    @Override
    public void purge(String prefix) throws IOException {
        String key = "";
        try {
            S3Object[] objects;
            for (S3Object object : objects = this.s3Service.listObjects(this.bucket.getName(), prefix, null)) {
                key = object.getKey();
                this.s3Service.deleteObject(this.bucket, key);
            }
        }
        catch (S3ServiceException e) {
            this.handleException((Exception)((Object)e), key);
        }
    }

    @Override
    public void dump() throws IOException {
        StringBuilder sb = new StringBuilder("S3 Native Filesystem, ");
        sb.append(this.bucket.getName()).append("\n");
        try {
            S3Object[] objects;
            for (S3Object object : objects = this.s3Service.listObjects(this.bucket.getName())) {
                sb.append(object.getKey()).append("\n");
            }
        }
        catch (S3ServiceException e) {
            this.handleException((Exception)((Object)e));
        }
        System.out.println(sb);
    }

    private void handleException(Exception e) throws IOException {
        throw this.processException(e, e, "");
    }

    private void handleException(Exception e, String key) throws IOException {
        throw this.processException(e, e, key);
    }

    private IOException processException(Throwable thrown, Throwable original, String key) {
        IOException result;
        if (thrown.getCause() != null) {
            result = this.processException(thrown.getCause(), original, key);
        } else if (thrown instanceof HttpException) {
            HttpException httpException = (HttpException)thrown;
            String responseMessage = httpException.getResponseMessage();
            int responseCode = httpException.getResponseCode();
            String bucketName = "s3n://" + this.bucket.getName();
            String text = String.format("%s : %03d : %s", bucketName, responseCode, responseMessage);
            String filename = !key.isEmpty() ? bucketName + "/" + key : text;
            switch (responseCode) {
                case 404: {
                    result = new FileNotFoundException(filename);
                    break;
                }
                case 416: {
                    result = new EOFException("Attempted to seek or read past the end of the file: " + filename);
                    break;
                }
                case 403: {
                    result = new AccessControlException("Permission denied: " + filename);
                    break;
                }
                default: {
                    result = new IOException(text);
                }
            }
            result.initCause(thrown);
        } else if (thrown instanceof S3ServiceException) {
            S3ServiceException se = (S3ServiceException)thrown;
            LOG.debug("S3ServiceException: {}: {} : {}", new Object[]{se.getS3ErrorCode(), se.getS3ErrorMessage(), se, se});
            result = "InvalidRange".equals(se.getS3ErrorCode()) ? new EOFException("Attempted to seek or read past the end of the file") : new S3Exception(se);
        } else if (thrown instanceof ServiceException) {
            ServiceException se = (ServiceException)thrown;
            LOG.debug("S3ServiceException: {}: {} : {}", new Object[]{se.getErrorCode(), se.toString(), se, se});
            result = new S3Exception(se);
        } else {
            result = thrown instanceof IOException ? (IOException)thrown : new S3Exception(original);
        }
        return result;
    }
}

