/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Random;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.DF;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileUtil;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.RawLocalFileSystem;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class LocalFileSystem
extends ChecksumFileSystem {
    static final URI NAME = URI.create("file:///");
    private static Random rand = new Random();

    public LocalFileSystem() {
        this(new RawLocalFileSystem());
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        String scheme;
        if (this.fs.getConf() == null) {
            this.fs.initialize(name, conf);
        }
        if (!(scheme = name.getScheme()).equals(this.fs.getUri().getScheme())) {
            this.swapScheme = scheme;
        }
    }

    @Override
    public String getScheme() {
        return "file";
    }

    public FileSystem getRaw() {
        return this.getRawFileSystem();
    }

    public LocalFileSystem(FileSystem rawLocalFileSystem) {
        super(rawLocalFileSystem);
    }

    public File pathToFile(Path path) {
        return ((RawLocalFileSystem)this.fs).pathToFile(path);
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this, src, this, dst, delSrc, this.getConf());
    }

    @Override
    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this, src, this, dst, delSrc, this.getConf());
    }

    @Override
    public boolean reportChecksumFailure(Path p, FSDataInputStream in, long inPos, FSDataInputStream sums, long sumsPos) {
        try {
            File f = ((RawLocalFileSystem)this.fs).pathToFile(p).getCanonicalFile();
            String device = new DF(f, this.getConf()).getMount();
            File dir = null;
            for (File parent = f.getParentFile(); parent != null && FileUtil.canWrite(parent) && parent.toString().startsWith(device); parent = parent.getParentFile()) {
                dir = parent;
            }
            if (dir == null) {
                throw new IOException("not able to find the highest writable parent dir");
            }
            File badDir = new File(dir, "bad_files");
            if (!badDir.mkdirs() && !badDir.isDirectory()) {
                throw new IOException("Mkdirs failed to create " + badDir.toString());
            }
            String suffix = "." + rand.nextInt();
            File badFile = new File(badDir, f.getName() + suffix);
            LOG.warn("Moving bad file " + f + " to " + badFile);
            in.close();
            boolean b = f.renameTo(badFile);
            if (!b) {
                LOG.warn("Ignoring failure of renameTo");
            }
            File checkFile = ((RawLocalFileSystem)this.fs).pathToFile(this.getChecksumFile(p));
            sums.close();
            b = checkFile.renameTo(new File(badDir, checkFile.getName() + suffix));
            if (!b) {
                LOG.warn("Ignoring failure of renameTo");
            }
        }
        catch (IOException e) {
            LOG.warn("Error moving bad file " + p + ": " + e);
        }
        return false;
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        this.fs.createSymlink(target, link, createParent);
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws IOException {
        return this.fs.getFileLinkStatus(f);
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        return this.fs.getLinkTarget(f);
    }
}

