/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.fs.hdfs.HadoopBlockLocation;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.fs.hdfs.HadoopDataInputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.fs.hdfs.HadoopDataOutputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.fs.hdfs.HadoopFileStatus;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.util.Preconditions;

public class HadoopFileSystem
extends FileSystem {
    private final org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem fs;
    private FileSystemKind fsKind;

    public HadoopFileSystem(org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem hadoopFileSystem) {
        this.fs = (org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem)Preconditions.checkNotNull((Object)hadoopFileSystem, (String)"hadoopFileSystem");
    }

    public org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem getHadoopFileSystem() {
        return this.fs;
    }

    public org.apache.flink.core.fs.Path getWorkingDirectory() {
        return new org.apache.flink.core.fs.Path(this.fs.getWorkingDirectory().toUri());
    }

    public org.apache.flink.core.fs.Path getHomeDirectory() {
        return new org.apache.flink.core.fs.Path(this.fs.getHomeDirectory().toUri());
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public FileStatus getFileStatus(org.apache.flink.core.fs.Path f) throws IOException {
        org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileStatus status = this.fs.getFileStatus(new Path(f.toString()));
        return new HadoopFileStatus(status);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!(file instanceof HadoopFileStatus)) {
            throw new IOException("file is not an instance of DistributedFileStatus");
        }
        HadoopFileStatus f = (HadoopFileStatus)file;
        org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.BlockLocation[] blkLocations = this.fs.getFileBlockLocations(f.getInternalFileStatus(), start, len);
        BlockLocation[] distBlkLocations = new HadoopBlockLocation[blkLocations.length];
        for (int i = 0; i < distBlkLocations.length; ++i) {
            distBlkLocations[i] = new HadoopBlockLocation(blkLocations[i]);
        }
        return distBlkLocations;
    }

    public HadoopDataInputStream open(org.apache.flink.core.fs.Path f, int bufferSize) throws IOException {
        Path path = new Path(f.toString());
        FSDataInputStream fdis = this.fs.open(path, bufferSize);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataInputStream open(org.apache.flink.core.fs.Path f) throws IOException {
        Path path = new Path(f.toString());
        FSDataInputStream fdis = this.fs.open(path);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataOutputStream create(org.apache.flink.core.fs.Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        FSDataOutputStream fdos = this.fs.create(new Path(f.toString()), overwrite, bufferSize, replication, blockSize);
        return new HadoopDataOutputStream(fdos);
    }

    public HadoopDataOutputStream create(org.apache.flink.core.fs.Path f, FileSystem.WriteMode overwrite) throws IOException {
        FSDataOutputStream fsDataOutputStream = this.fs.create(new Path(f.toString()), overwrite == FileSystem.WriteMode.OVERWRITE);
        return new HadoopDataOutputStream(fsDataOutputStream);
    }

    public boolean delete(org.apache.flink.core.fs.Path f, boolean recursive) throws IOException {
        return this.fs.delete(new Path(f.toString()), recursive);
    }

    public FileStatus[] listStatus(org.apache.flink.core.fs.Path f) throws IOException {
        org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileStatus[] hadoopFiles = this.fs.listStatus(new Path(f.toString()));
        FileStatus[] files = new FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new HadoopFileStatus(hadoopFiles[i]);
        }
        return files;
    }

    public boolean mkdirs(org.apache.flink.core.fs.Path f) throws IOException {
        return this.fs.mkdirs(new Path(f.toString()));
    }

    public boolean rename(org.apache.flink.core.fs.Path src, org.apache.flink.core.fs.Path dst) throws IOException {
        return this.fs.rename(new Path(src.toString()), new Path(dst.toString()));
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public boolean isDistributedFS() {
        return true;
    }

    public FileSystemKind getKind() {
        if (this.fsKind == null) {
            this.fsKind = HadoopFileSystem.getKindForScheme(this.fs.getUri().getScheme());
        }
        return this.fsKind;
    }

    static FileSystemKind getKindForScheme(String scheme) {
        if ((scheme = scheme.toLowerCase(Locale.US)).startsWith("s3") || scheme.startsWith("emr")) {
            return FileSystemKind.OBJECT_STORE;
        }
        if (scheme.startsWith("http") || scheme.startsWith("ftp")) {
            return FileSystemKind.OBJECT_STORE;
        }
        return FileSystemKind.FILE_SYSTEM;
    }
}

