/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.configuration.AbstractConfiguration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.configuration.ConfigurationUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.configuration.PropertyConverter;

public class MapConfiguration
extends AbstractConfiguration
implements Cloneable {
    protected Map map;
    private boolean trimmingDisabled;

    public MapConfiguration(Map map) {
        this.map = map;
    }

    public Map getMap() {
        return this.map;
    }

    public boolean isTrimmingDisabled() {
        return this.trimmingDisabled;
    }

    public void setTrimmingDisabled(boolean trimmingDisabled) {
        this.trimmingDisabled = trimmingDisabled;
    }

    public Object getProperty(String key) {
        Object value = this.map.get(key);
        if (value instanceof String && !this.isDelimiterParsingDisabled()) {
            List list = PropertyConverter.split((String)value, this.getListDelimiter(), !this.isTrimmingDisabled());
            return list.size() > 1 ? list : list.get(0);
        }
        return value;
    }

    protected void addPropertyDirect(String key, Object value) {
        Object previousValue = this.getProperty(key);
        if (previousValue == null) {
            this.map.put(key, value);
        } else if (previousValue instanceof List) {
            ((List)previousValue).add(value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(previousValue);
            list.add(value);
            this.map.put(key, list);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    protected void clearPropertyDirect(String key) {
        this.map.remove(key);
    }

    public Iterator getKeys() {
        return this.map.keySet().iterator();
    }

    public Object clone() {
        try {
            MapConfiguration copy = (MapConfiguration)super.clone();
            copy.clearConfigurationListeners();
            copy.map = (Map)ConfigurationUtils.clone(this.map);
            return copy;
        }
        catch (CloneNotSupportedException cex) {
            throw new ConfigurationRuntimeException(cex);
        }
    }
}

