/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.flink.fs.s3hadoop.shaded.com.nimbusds.jose.crypto.BaseJWEProvider;

abstract class RSACryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;

    protected RSACryptoProvider() {
        super(SUPPORTED_ALGORITHMS, SUPPORTED_ENCRYPTION_METHODS);
    }

    static {
        HashSet<JWEAlgorithm> algs = new HashSet<JWEAlgorithm>();
        algs.add(JWEAlgorithm.RSA1_5);
        algs.add(JWEAlgorithm.RSA_OAEP);
        algs.add(JWEAlgorithm.RSA_OAEP_256);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
        HashSet<EncryptionMethod> methods = new HashSet<EncryptionMethod>();
        methods.add(EncryptionMethod.A128CBC_HS256);
        methods.add(EncryptionMethod.A192CBC_HS384);
        methods.add(EncryptionMethod.A256CBC_HS512);
        methods.add(EncryptionMethod.A128GCM);
        methods.add(EncryptionMethod.A192GCM);
        methods.add(EncryptionMethod.A256GCM);
        methods.add(EncryptionMethod.A128CBC_HS256_DEPRECATED);
        methods.add(EncryptionMethod.A256CBC_HS512_DEPRECATED);
        SUPPORTED_ENCRYPTION_METHODS = Collections.unmodifiableSet(methods);
    }
}

