/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.crypto;

import java.io.File;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.internal.SdkFilterInputStream;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.kms.AWSKMS;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.S3Direct;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.crypto.ByteRangeCapturingInputStream;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.crypto.CipherLite;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.crypto.ContentCryptoMaterial;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.crypto.MultipartUploadCbcContext;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.crypto.S3CryptoModuleBase;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.CryptoConfiguration;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.CryptoMode;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.GetObjectRequest;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.S3Object;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.UploadPartRequest;

class S3CryptoModuleEO
extends S3CryptoModuleBase<MultipartUploadCbcContext> {
    S3CryptoModuleEO(AWSKMS kms, S3Direct s3, AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        super(kms, s3, credentialsProvider, encryptionMaterialsProvider, cryptoConfig);
        if (cryptoConfig.getCryptoMode() != CryptoMode.EncryptionOnly) {
            throw new IllegalArgumentException();
        }
    }

    S3CryptoModuleEO(S3Direct s3, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this(null, s3, new DefaultAWSCredentialsProviderChain(), encryptionMaterialsProvider, cryptoConfig);
    }

    S3CryptoModuleEO(AWSKMS kms, S3Direct s3, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this(kms, s3, new DefaultAWSCredentialsProviderChain(), encryptionMaterialsProvider, cryptoConfig);
    }

    @Override
    public S3Object getObjectSecurely(GetObjectRequest getObjectRequest) {
        throw new IllegalStateException();
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File destinationFile) {
        throw new IllegalStateException();
    }

    @Override
    final MultipartUploadCbcContext newUploadContext(InitiateMultipartUploadRequest req, ContentCryptoMaterial cekMaterial) {
        MultipartUploadCbcContext encryptedUploadContext = new MultipartUploadCbcContext(req.getBucketName(), req.getKey(), cekMaterial);
        byte[] iv = cekMaterial.getCipherLite().getIV();
        encryptedUploadContext.setNextInitializationVector(iv);
        return encryptedUploadContext;
    }

    @Override
    final void updateUploadContext(MultipartUploadCbcContext uploadContext, SdkFilterInputStream is) {
        ByteRangeCapturingInputStream bis = (ByteRangeCapturingInputStream)is;
        uploadContext.setNextInitializationVector(bis.getBlock());
    }

    final ByteRangeCapturingInputStream wrapForMultipart(CipherLiteInputStream is, long partSize) {
        int blockSize = this.contentCryptoScheme.getBlockSizeInBytes();
        return new ByteRangeCapturingInputStream(is, partSize - (long)blockSize, partSize);
    }

    @Override
    final long computeLastPartSize(UploadPartRequest request) {
        long plaintextLength;
        if (request.getFile() != null) {
            plaintextLength = request.getPartSize() > 0L ? request.getPartSize() : request.getFile().length();
        } else if (request.getInputStream() != null) {
            plaintextLength = request.getPartSize();
        } else {
            return -1L;
        }
        long cipherBlockSize = this.contentCryptoScheme.getBlockSizeInBytes();
        long offset = cipherBlockSize - plaintextLength % cipherBlockSize;
        return plaintextLength + offset;
    }

    @Override
    final CipherLite cipherLiteForNextPart(MultipartUploadCbcContext uploadContext) {
        CipherLite cipherLite = uploadContext.getCipherLite();
        byte[] nextIV = uploadContext.getNextInitializationVector();
        return cipherLite.createUsingIV(nextIV);
    }

    @Override
    protected final long ciphertextLength(long plaintextLength) {
        long cipherBlockSize = this.contentCryptoScheme.getBlockSizeInBytes();
        long offset = cipherBlockSize - plaintextLength % cipherBlockSize;
        return plaintextLength + offset;
    }
}

