/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.http.HttpMethodName;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.http.HttpResponse;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.http.HttpResponseHandler;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.internal.AmazonS3ExceptionBuilder;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.services.s3.model.AmazonS3Exception;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.util.IOUtils;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.util.StringUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.commons.logging.LogFactory;

public class S3ErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(S3ErrorResponseHandler.class);
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    @Override
    public AmazonServiceException handle(HttpResponse httpResponse) throws XMLStreamException {
        AmazonServiceException exception = this.createException(httpResponse);
        exception.setHttpHeaders(httpResponse.getHeaders());
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AmazonServiceException createException(HttpResponse httpResponse) throws XMLStreamException {
        String content;
        block22: {
            XMLStreamReader reader;
            InputStream is = httpResponse.getContent();
            String xmlContent = null;
            if (is == null || httpResponse.getRequest().getHttpMethod() == HttpMethodName.HEAD) {
                return this.createExceptionFromHeaders(httpResponse, null);
            }
            content = null;
            try {
                content = IOUtils.toString(is);
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed in parsing the error response : ", ioe);
                }
                return this.createExceptionFromHeaders(httpResponse, null);
            }
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                reader = xmlInputFactory.createXMLStreamReader(new ByteArrayInputStream(content.getBytes(StringUtils.UTF8)));
            }
            try {
                int targetDepth = 0;
                AmazonS3ExceptionBuilder exceptionBuilder = new AmazonS3ExceptionBuilder();
                exceptionBuilder.setErrorResponseXml(content);
                exceptionBuilder.setStatusCode(httpResponse.getStatusCode());
                exceptionBuilder.setCloudFrontId(httpResponse.getHeaders().get("X-Amz-Cf-Id"));
                boolean hasErrorTagVisited = false;
                block13: while (reader.hasNext()) {
                    int event = reader.next();
                    switch (event) {
                        case 1: {
                            String tagName = reader.getLocalName();
                            if (++targetDepth == 1 && !S3ErrorTags.Error.toString().equals(tagName)) {
                                return this.createExceptionFromHeaders(httpResponse, "Unable to parse error response. Error XML Not in proper format." + content);
                            }
                            if (!S3ErrorTags.Error.toString().equals(tagName)) continue block13;
                            hasErrorTagVisited = true;
                            continue block13;
                        }
                        case 4: {
                            xmlContent = reader.getText();
                            if (xmlContent == null) continue block13;
                            xmlContent = xmlContent.trim();
                            continue block13;
                        }
                        case 2: {
                            String tagName = reader.getLocalName();
                            if (!hasErrorTagVisited || --targetDepth > 1) {
                                return this.createExceptionFromHeaders(httpResponse, "Unable to parse error response. Error XML Not in proper format." + content);
                            }
                            if (S3ErrorTags.Message.toString().equals(tagName)) {
                                exceptionBuilder.setErrorMessage(xmlContent);
                                continue block13;
                            }
                            if (S3ErrorTags.Code.toString().equals(tagName)) {
                                exceptionBuilder.setErrorCode(xmlContent);
                                continue block13;
                            }
                            if (S3ErrorTags.RequestId.toString().equals(tagName)) {
                                exceptionBuilder.setRequestId(xmlContent);
                                continue block13;
                            }
                            if (S3ErrorTags.HostId.toString().equals(tagName)) {
                                exceptionBuilder.setExtendedRequestId(xmlContent);
                                continue block13;
                            }
                            exceptionBuilder.addAdditionalDetail(tagName, xmlContent);
                            continue block13;
                        }
                        case 8: {
                            return exceptionBuilder.build();
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block22;
                log.debug("Failed in parsing the error response : " + content, e);
            }
        }
        return this.createExceptionFromHeaders(httpResponse, content);
    }

    private AmazonS3Exception createExceptionFromHeaders(HttpResponse errorResponse, String errorResponseXml) {
        Map<String, String> headers = errorResponse.getHeaders();
        int statusCode = errorResponse.getStatusCode();
        AmazonS3ExceptionBuilder exceptionBuilder = new AmazonS3ExceptionBuilder();
        exceptionBuilder.setErrorMessage(errorResponse.getStatusText());
        exceptionBuilder.setErrorResponseXml(errorResponseXml);
        exceptionBuilder.setStatusCode(statusCode);
        exceptionBuilder.setExtendedRequestId(headers.get("x-amz-id-2"));
        exceptionBuilder.setRequestId(headers.get("x-amz-request-id"));
        exceptionBuilder.setCloudFrontId(headers.get("X-Amz-Cf-Id"));
        exceptionBuilder.setErrorCode(statusCode + " " + errorResponse.getStatusText());
        exceptionBuilder.addAdditionalDetail("x-amz-bucket-region", errorResponse.getHeaders().get("x-amz-bucket-region"));
        return exceptionBuilder.build();
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private static enum S3ErrorTags {
        Error,
        Message,
        Code,
        RequestId,
        HostId;

    }
}

