/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.retry.v2;

import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.retry.v2.RetryCondition;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.retry.v2.RetryPolicyContext;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.util.ValidationUtils;

public class MaxNumberOfRetriesCondition
implements RetryCondition {
    private final int maxNumberOfRetries;

    public MaxNumberOfRetriesCondition(int maxNumberOfRetries) {
        this.maxNumberOfRetries = ValidationUtils.assertIsPositive(maxNumberOfRetries, "maxNumberOfRetries");
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return context.retriesAttempted() < this.maxNumberOfRetries;
    }
}

