/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.client.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.AmazonWebServiceClient;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.ClientConfigurationFactory;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.annotation.NotThreadSafe;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.annotation.SdkProtectedApi;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.annotation.SdkTestInternalApi;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.client.AwsAsyncClientParams;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.client.AwsSyncClientParams;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.handlers.RequestHandler2;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.metrics.RequestMetricCollector;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.regions.AwsRegionProvider;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.regions.DefaultAwsRegionProviderChain;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.regions.Region;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.regions.RegionUtils;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.regions.Regions;

@NotThreadSafe
@SdkProtectedApi
public abstract class AwsClientBuilder<Subclass extends AwsClientBuilder, TypeToBuild> {
    private static final AwsRegionProvider DEFAULT_REGION_PROVIDER = new DefaultAwsRegionProviderChain();
    private final ClientConfigurationFactory clientConfigFactory;
    private final AwsRegionProvider regionProvider;
    private AWSCredentialsProvider credentials;
    private ClientConfiguration clientConfig;
    private RequestMetricCollector metricsCollector;
    private Region region;
    private List<RequestHandler2> requestHandlers;
    private EndpointConfiguration endpointConfiguration;

    protected AwsClientBuilder(ClientConfigurationFactory clientConfigFactory) {
        this(clientConfigFactory, DEFAULT_REGION_PROVIDER);
    }

    @SdkTestInternalApi
    protected AwsClientBuilder(ClientConfigurationFactory clientConfigFactory, AwsRegionProvider regionProvider) {
        this.clientConfigFactory = clientConfigFactory;
        this.regionProvider = regionProvider;
    }

    public final AWSCredentialsProvider getCredentials() {
        return this.credentials;
    }

    public final void setCredentials(AWSCredentialsProvider credentialsProvider) {
        this.credentials = credentialsProvider;
    }

    public final Subclass withCredentials(AWSCredentialsProvider credentialsProvider) {
        this.setCredentials(credentialsProvider);
        return this.getSubclass();
    }

    private AWSCredentialsProvider resolveCredentials() {
        return this.credentials == null ? DefaultAWSCredentialsProviderChain.getInstance() : this.credentials;
    }

    public final ClientConfiguration getClientConfiguration() {
        return this.clientConfig;
    }

    public final void setClientConfiguration(ClientConfiguration config) {
        this.clientConfig = config;
    }

    public final Subclass withClientConfiguration(ClientConfiguration config) {
        this.setClientConfiguration(config);
        return this.getSubclass();
    }

    private ClientConfiguration resolveClientConfiguration() {
        return this.clientConfig == null ? this.clientConfigFactory.getConfig() : new ClientConfiguration(this.clientConfig);
    }

    public final RequestMetricCollector getMetricsCollector() {
        return this.metricsCollector;
    }

    public final void setMetricsCollector(RequestMetricCollector metrics) {
        this.metricsCollector = metrics;
    }

    public final Subclass withMetricsCollector(RequestMetricCollector metrics) {
        this.setMetricsCollector(metrics);
        return this.getSubclass();
    }

    public final String getRegion() {
        return this.region == null ? null : this.region.getName();
    }

    public final void setRegion(String region) {
        this.withRegion(region);
    }

    public final Subclass withRegion(Regions region) {
        return this.withRegion(region.getName());
    }

    public final Subclass withRegion(String region) {
        return this.withRegion(RegionUtils.getRegion(region));
    }

    private Subclass withRegion(Region region) {
        this.region = region;
        return this.getSubclass();
    }

    public final EndpointConfiguration getEndpoint() {
        return this.endpointConfiguration;
    }

    public final void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.withEndpointConfiguration(endpointConfiguration);
    }

    public final Subclass withEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        return this.getSubclass();
    }

    public final List<RequestHandler2> getRequestHandlers() {
        return this.requestHandlers == null ? null : Collections.unmodifiableList(this.requestHandlers);
    }

    public final void setRequestHandlers(RequestHandler2 ... handlers) {
        this.requestHandlers = Arrays.asList(handlers);
    }

    public final Subclass withRequestHandlers(RequestHandler2 ... handlers) {
        this.setRequestHandlers(handlers);
        return this.getSubclass();
    }

    private List<RequestHandler2> resolveRequestHandlers() {
        return this.requestHandlers == null ? new ArrayList<RequestHandler2>() : new ArrayList<RequestHandler2>(this.requestHandlers);
    }

    @SdkInternalApi
    final TypeToBuild configureMutableProperties(TypeToBuild clientInterface) {
        AmazonWebServiceClient client = (AmazonWebServiceClient)clientInterface;
        this.setRegion(client);
        client.makeImmutable();
        return clientInterface;
    }

    public abstract TypeToBuild build();

    protected final AwsSyncClientParams getSyncClientParams() {
        return new SyncBuilderParams();
    }

    private void setRegion(AmazonWebServiceClient client) {
        if (this.region != null && this.endpointConfiguration != null) {
            throw new IllegalStateException("Only one of Region or EndpointConfiguration may be set.");
        }
        if (this.endpointConfiguration != null) {
            client.setEndpoint(this.endpointConfiguration.getServiceEndpoint());
            client.setSignerRegionOverride(this.endpointConfiguration.getSigningRegion());
        } else if (this.region != null) {
            client.setRegion(this.region);
        } else {
            String region = this.determineRegionFromRegionProvider();
            if (region != null) {
                client.setRegion(RegionUtils.getRegion(region));
            } else {
                throw new SdkClientException("Unable to find a region via the region provider chain. Must provide an explicit region in the builder or setup environment to supply a region.");
            }
        }
    }

    private String determineRegionFromRegionProvider() {
        try {
            return this.regionProvider.getRegion();
        }
        catch (SdkClientException e) {
            return null;
        }
    }

    protected final Subclass getSubclass() {
        return (Subclass)this;
    }

    public static final class EndpointConfiguration {
        private final String serviceEndpoint;
        private final String signingRegion;

        public EndpointConfiguration(String serviceEndpoint, String signingRegion) {
            this.serviceEndpoint = serviceEndpoint;
            this.signingRegion = signingRegion;
        }

        public String getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        public String getSigningRegion() {
            return this.signingRegion;
        }
    }

    protected class SyncBuilderParams
    extends AwsAsyncClientParams {
        private final ClientConfiguration _clientConfig;
        private final AWSCredentialsProvider _credentials;
        private final RequestMetricCollector _metricsCollector;
        private final List<RequestHandler2> _requestHandlers;

        protected SyncBuilderParams() {
            this._clientConfig = AwsClientBuilder.this.resolveClientConfiguration();
            this._credentials = AwsClientBuilder.this.resolveCredentials();
            this._metricsCollector = AwsClientBuilder.this.metricsCollector;
            this._requestHandlers = AwsClientBuilder.this.resolveRequestHandlers();
        }

        @Override
        public AWSCredentialsProvider getCredentialsProvider() {
            return this._credentials;
        }

        @Override
        public ClientConfiguration getClientConfiguration() {
            return this._clientConfig;
        }

        @Override
        public RequestMetricCollector getRequestMetricCollector() {
            return this._metricsCollector;
        }

        @Override
        public List<RequestHandler2> getRequestHandlers() {
            return this._requestHandlers;
        }

        @Override
        public ExecutorService getExecutor() {
            throw new UnsupportedOperationException("ExecutorService is not used for sync client.");
        }
    }
}

