/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.auth;

import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.auth.AWSCredentials;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.auth.BasicAWSCredentials;
import org.apache.flink.fs.s3hadoop.shaded.com.amazonaws.util.StringUtils;

public class SystemPropertiesCredentialsProvider
implements AWSCredentialsProvider {
    @Override
    public AWSCredentials getCredentials() {
        String accessKey = StringUtils.trim(System.getProperty("aws.accessKeyId"));
        String secretKey = StringUtils.trim(System.getProperty("aws.secretKey"));
        if (StringUtils.isNullOrEmpty(accessKey) || StringUtils.isNullOrEmpty(secretKey)) {
            throw new SdkClientException("Unable to load AWS credentials from Java system properties (aws.accessKeyId and aws.secretKey)");
        }
        return new BasicAWSCredentials(accessKey, secretKey);
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

