/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3hadoop;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3hadoop.shaded.org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystemFactory
implements FileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(S3FileSystemFactory.class);
    private static final String[] CONFIG_PREFIXES = new String[]{"s3.", "s3a.", "fs.s3a."};
    private static final String[][] MIRRORED_CONFIG_KEYS = new String[][]{{"fs.s3a.access-key", "fs.s3a.access.key"}, {"fs.s3a.secret-key", "fs.s3a.secret.key"}};
    private org.apache.flink.configuration.Configuration flinkConfig;
    private Configuration hadoopConfig;

    public String getScheme() {
        return "s3";
    }

    public void configure(org.apache.flink.configuration.Configuration config) {
        this.flinkConfig = config;
        this.hadoopConfig = null;
    }

    public org.apache.flink.core.fs.FileSystem create(URI fsUri) throws IOException {
        LOG.debug("Creating S3 file system (backed by a Hadoop s3a file system)");
        try {
            URI defaultUri;
            Configuration hadoopConfig = this.hadoopConfig;
            if (hadoopConfig == null) {
                if (this.flinkConfig != null) {
                    LOG.debug("Loading Hadoop configuration for s3a file system");
                    hadoopConfig = HadoopUtils.getHadoopConfiguration(this.flinkConfig);
                    for (String key : this.flinkConfig.keySet()) {
                        for (String prefix : CONFIG_PREFIXES) {
                            if (!key.startsWith(prefix)) continue;
                            String value = this.flinkConfig.getString(key, null);
                            String newKey = "fs.s3a." + key.substring(prefix.length());
                            hadoopConfig.set(newKey, this.flinkConfig.getString(key, null));
                            LOG.debug("Adding Flink config entry for {} as {}={} to Hadoop config for S3A File System", new Object[]{key, newKey, value});
                        }
                    }
                    for (String[] mirrored : MIRRORED_CONFIG_KEYS) {
                        String value = hadoopConfig.get(mirrored[0], null);
                        if (value == null) continue;
                        hadoopConfig.set(mirrored[1], value);
                    }
                    this.hadoopConfig = hadoopConfig;
                } else {
                    LOG.warn("The factory has not been configured prior to loading the S3 file system. Using Hadoop configuration from the classpath.");
                    this.hadoopConfig = hadoopConfig = new Configuration();
                }
            }
            String scheme = fsUri.getScheme();
            String authority = fsUri.getAuthority();
            if (scheme == null && authority == null) {
                fsUri = FileSystem.getDefaultUri(hadoopConfig);
            } else if (scheme != null && authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri(hadoopConfig)).getScheme()) && defaultUri.getAuthority() != null) {
                fsUri = defaultUri;
            }
            LOG.debug("Using scheme {} for s3a file system backing the S3 File System", (Object)fsUri);
            S3AFileSystem fs = new S3AFileSystem();
            fs.initialize(fsUri, hadoopConfig);
            return new HadoopFileSystem(fs);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

