/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ZooKeeperUtilTest
extends TestLogger {
    @Test
    public void testZooKeeperEnsembleConnectStringConfiguration() throws Exception {
        Configuration conf = new Configuration();
        String expected = "localhost:2891";
        this.setQuorum(conf, expected);
        String actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assert.assertEquals((Object)expected, (Object)actual);
        this.setQuorum(conf, " localhost:2891 ");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assert.assertEquals((Object)expected, (Object)actual);
        this.setQuorum(conf, "localhost :2891");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = "localhost:2891,localhost:2891";
        this.setQuorum(conf, "localhost:2891,localhost:2891");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assert.assertEquals((Object)expected, (Object)actual);
        this.setQuorum(conf, "localhost:2891, localhost:2891");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assert.assertEquals((Object)expected, (Object)actual);
        this.setQuorum(conf, "localhost :2891, localhost:2891");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assert.assertEquals((Object)expected, (Object)actual);
        this.setQuorum(conf, " localhost:2891, localhost:2891 ");
        actual = ZooKeeperUtils.getZooKeeperEnsemble((Configuration)conf);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private Configuration setQuorum(Configuration conf, String quorum) {
        conf.setString("recovery.zookeeper.quorum", quorum);
        return conf;
    }
}

