/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;

public class ZooKeeperTestUtils {
    public static Configuration createZooKeeperRecoveryModeConfig(String zooKeeperQuorum, String fsStateHandlePath) {
        return ZooKeeperTestUtils.setZooKeeperRecoveryMode(new Configuration(), zooKeeperQuorum, fsStateHandlePath);
    }

    public static Configuration setZooKeeperRecoveryMode(Configuration config, String zooKeeperQuorum, String fsStateHandlePath) {
        Preconditions.checkNotNull((Object)config, (String)"Configuration");
        Preconditions.checkNotNull((Object)zooKeeperQuorum, (String)"ZooKeeper quorum");
        Preconditions.checkNotNull((Object)fsStateHandlePath, (String)"File state handle backend path");
        config.setInteger("jobmanager.web.port", -1);
        config.setString("recovery.mode", "ZOOKEEPER");
        config.setString("recovery.zookeeper.quorum", zooKeeperQuorum);
        int connTimeout = 5000;
        if (System.getenv().containsKey("CI")) {
            connTimeout = 30000;
        }
        config.setInteger("recovery.zookeeper.client.connection-timeout", connTimeout);
        config.setInteger("recovery.zookeeper.client.session-timeout", connTimeout);
        config.setString("state.backend", "FILESYSTEM");
        config.setString("state.backend.fs.checkpointdir", fsStateHandlePath + "/checkpoints");
        config.setString("recovery.zookeeper.storageDir", fsStateHandlePath + "/recovery");
        config.setString("akka.watch.heartbeat.interval", "1000 ms");
        config.setString("akka.watch.heartbeat.pause", "6 s");
        config.setInteger("akka.watch.threshold", 9);
        config.setString("akka.ask.timeout", "100 s");
        config.setString("recovery.job.delay", "10 s");
        return config;
    }
}

