/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.testutils.TestJvmProcess;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerProcess
extends TestJvmProcess {
    private final int id;
    private final Configuration config;
    private final String[] jvmArgs;

    public TaskManagerProcess(int id, Configuration config) throws Exception {
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"Negative ID");
        this.id = id;
        this.config = (Configuration)Preconditions.checkNotNull((Object)config, (String)"Configuration");
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry entry : config.toMap().entrySet()) {
            args.add("--" + (String)entry.getKey());
            args.add((String)entry.getValue());
        }
        this.jvmArgs = new String[args.size()];
        args.toArray(this.jvmArgs);
    }

    @Override
    public String getName() {
        return "TaskManager " + this.id;
    }

    @Override
    public String[] getJvmArgs() {
        return this.jvmArgs;
    }

    @Override
    public String getEntryPointClassName() {
        return TaskManagerProcessEntryPoint.class.getName();
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return String.format("TaskManagerProcess(id=%d)", this.id);
    }

    public static class TaskManagerProcessEntryPoint {
        private static final Logger LOG = LoggerFactory.getLogger(TaskManagerProcessEntryPoint.class);

        public static void main(String[] args) throws Exception {
            try {
                Configuration config = ParameterTool.fromArgs((String[])args).getConfiguration();
                if (!config.containsKey("taskmanager.memory.size")) {
                    config.setInteger("taskmanager.memory.size", 4);
                }
                if (!config.containsKey("taskmanager.network.numberOfBuffers")) {
                    config.setInteger("taskmanager.network.numberOfBuffers", 100);
                }
                LOG.info("Configuration: {}.", (Object)config);
                TaskManager.selectNetworkInterfaceAndRunTaskManager((Configuration)config, (ResourceID)ResourceID.generate(), TaskManager.class);
                new CountDownLatch(1).await();
            }
            catch (Throwable t) {
                LOG.error("Failed to start TaskManager process", t);
                System.exit(1);
            }
        }
    }
}

