/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.util.StartupUtils;
import org.junit.Assert;
import org.junit.Test;

public class TaskManagerStartupTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=BindException.class)
    public void testStartupWhenTaskmanagerActorPortIsUsed() throws BindException {
        ServerSocket blocker = null;
        try {
            String localHostName = "localhost";
            InetAddress localAddress = InetAddress.getByName("localhost");
            blocker = new ServerSocket(0, 50, localAddress);
            int port = blocker.getLocalPort();
            TaskManager.runTaskManager((String)"localhost", (ResourceID)ResourceID.generate(), (int)port, (Configuration)new Configuration(), TaskManager.class);
            Assert.fail((String)"This should fail with an IOException");
        }
        catch (IOException e) {
            List<Throwable> causes = StartupUtils.getExceptionCauses(e, new ArrayList<Throwable>());
            for (Throwable cause : causes) {
                if (!(cause instanceof BindException)) continue;
                throw (BindException)cause;
            }
            Assert.fail((String)"This should fail with an exception caused by BindException");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (blocker != null) {
                try {
                    blocker.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIODirectoryNotWritable() {
        File tempDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH);
        File nonWritable = new File(tempDir, UUID.randomUUID().toString());
        if (!nonWritable.mkdirs() || !nonWritable.setWritable(false, false)) {
            System.err.println("Cannot create non-writable temporary file directory. Skipping test.");
            return;
        }
        try {
            Configuration cfg = new Configuration();
            cfg.setString("taskmanager.tmp.dirs", nonWritable.getAbsolutePath());
            cfg.setInteger("taskmanager.memory.size", 4);
            cfg.setString("jobmanager.rpc.address", "localhost");
            cfg.setInteger("jobmanager.rpc.port", 21656);
            try {
                TaskManager.runTaskManager((String)"localhost", (ResourceID)ResourceID.generate(), (int)0, (Configuration)cfg);
                Assert.fail((String)"Should fail synchronously with an exception");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            nonWritable.setWritable(true, false);
            try {
                FileUtils.deleteDirectory((File)nonWritable);
            }
            catch (IOException iOException) {}
        }
    }

    @Test
    public void testMemoryConfigWrong() {
        try {
            Configuration cfg = new Configuration();
            cfg.setString("jobmanager.rpc.address", "localhost");
            cfg.setInteger("jobmanager.rpc.port", 21656);
            cfg.setString("taskmanager.memory.preallocate", "true");
            cfg.setInteger("taskmanager.memory.size", -42);
            try {
                TaskManager.runTaskManager((String)"localhost", (ResourceID)ResourceID.generate(), (int)0, (Configuration)cfg);
                Assert.fail((String)"Should fail synchronously with an exception");
            }
            catch (IllegalConfigurationException illegalConfigurationException) {
                // empty catch block
            }
            long memSize = 0x3FFFFFFL;
            cfg.setLong("taskmanager.memory.size", 0x3FFFFFFL);
            try {
                TaskManager.runTaskManager((String)"localhost", (ResourceID)ResourceID.generate(), (int)0, (Configuration)cfg);
                Assert.fail((String)"Should fail synchronously with an exception");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof OutOfMemoryError));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

