/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.messages.NotifyResourceStarted;
import org.apache.flink.runtime.clusterframework.messages.RegisterResourceManager;
import org.apache.flink.runtime.clusterframework.messages.RegisterResourceManagerSuccessful;
import org.apache.flink.runtime.clusterframework.messages.RemoveResource;
import org.apache.flink.runtime.clusterframework.messages.ResourceRemoved;
import org.apache.flink.runtime.clusterframework.messages.TriggerRegistrationAtJobManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.TestingResourceManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import scala.Option;

public class ResourceManagerTest {
    private static ActorSystem system;
    private static ActorGateway fakeJobManager;
    private static ActorGateway resourceManager;
    private static Configuration config;

    @BeforeClass
    public static void setup() {
        system = AkkaUtils.createLocalActorSystem((Configuration)config);
    }

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
    }

    @Test
    public void testJobManagerRegistrationAndReconciliation() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(1.duration((String)"10 seconds")){

                    protected void run() {
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), (Option<String>)Option.empty());
                        resourceManager = TestingUtils.createResourceManager(system, fakeJobManager.actor(), config);
                        this.expectMsgClass(RegisterResourceManager.class);
                        ArrayList<ResourceID> resourceList = new ArrayList<ResourceID>();
                        resourceList.add(ResourceID.generate());
                        resourceList.add(ResourceID.generate());
                        resourceList.add(ResourceID.generate());
                        resourceManager.tell((Object)new RegisterResourceManagerSuccessful(fakeJobManager.actor(), resourceList), fakeJobManager);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        for (ResourceID id : resourceList) {
                            if (reply.resources.contains(id)) continue;
                            Assert.fail((String)"Expected to find all resources that were provided during registration.");
                        }
                    }
                };
            }
        };
    }

    @Test
    public void testDelayedJobManagerRegistration() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(2.duration((String)"10 seconds")){

                    protected void run() {
                        Configuration shortTimeoutConfig = config.clone();
                        shortTimeoutConfig.setString("akka.lookup.timeout", "1 s");
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), (Option<String>)Option.empty());
                        resourceManager = TestingUtils.createResourceManager(system, fakeJobManager.actor(), shortTimeoutConfig);
                        RegisterResourceManager msg = (RegisterResourceManager)this.expectMsgClass(RegisterResourceManager.class);
                        this.getLastSender().tell((Object)new JobManagerMessages.LeaderSessionMessage(null, new Object()), fakeJobManager.actor());
                        this.expectMsgClass(RegisterResourceManager.class);
                        this.expectMsgClass(RegisterResourceManager.class);
                    }
                };
            }
        };
    }

    @Test
    public void testTriggerReconnect() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(3.duration((String)"10 seconds")){

                    protected void run() {
                        Configuration shortTimeoutConfig = config.clone();
                        shortTimeoutConfig.setString("akka.lookup.timeout", "99999 s");
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), (Option<String>)Option.empty());
                        resourceManager = TestingUtils.createResourceManager(system, fakeJobManager.actor(), shortTimeoutConfig);
                        RegisterResourceManager msg = (RegisterResourceManager)this.expectMsgClass(RegisterResourceManager.class);
                        resourceManager.tell((Object)new RegisterResourceManagerSuccessful(fakeJobManager.actor(), Collections.emptyList()), fakeJobManager);
                        resourceManager.tell((Object)new TriggerRegistrationAtJobManager(fakeJobManager.actor()), fakeJobManager);
                        this.expectMsgClass(RegisterResourceManager.class);
                    }
                };
            }
        };
    }

    @Test
    public void testTaskManagerRegistration() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(4.duration((String)"10 seconds")){

                    protected void run() {
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), (Option<String>)Option.empty());
                        resourceManager = TestingUtils.createResourceManager(system, fakeJobManager.actor(), config);
                        this.expectMsgClass(RegisterResourceManager.class);
                        resourceManager.tell((Object)new RegisterResourceManagerSuccessful(fakeJobManager.actor(), Collections.emptyList()), fakeJobManager);
                        ResourceID resourceID = ResourceID.generate();
                        resourceManager.tell((Object)new NotifyResourceStarted(resourceID), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)1L, (long)reply.resources.size());
                        resourceManager.tell((Object)new NotifyResourceStarted(resourceID), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)1L, (long)reply.resources.size());
                        resourceManager.tell((Object)new NotifyResourceStarted(null), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)1L, (long)reply.resources.size());
                    }
                };
            }
        };
    }

    @Test
    public void testResourceRemoval() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(5.duration((String)"10 seconds")){

                    protected void run() {
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), (Option<String>)Option.empty());
                        resourceManager = TestingUtils.createResourceManager(system, fakeJobManager.actor(), config);
                        this.expectMsgClass(RegisterResourceManager.class);
                        resourceManager.tell((Object)new RegisterResourceManagerSuccessful(fakeJobManager.actor(), Collections.emptyList()), fakeJobManager);
                        ResourceID resourceID = ResourceID.generate();
                        resourceManager.tell((Object)new RemoveResource(resourceID), fakeJobManager);
                        resourceManager.tell((Object)new NotifyResourceStarted(resourceID), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)1L, (long)reply.resources.size());
                        Assert.assertTrue((boolean)reply.resources.contains(resourceID));
                        resourceManager.tell((Object)new RemoveResource(resourceID), fakeJobManager);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)0L, (long)reply.resources.size());
                    }
                };
            }
        };
    }

    @Test
    public void testResourceFailureNotification() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(6.duration((String)"10 seconds")){

                    protected void run() {
                        fakeJobManager = TestingUtils.createForwardingActor(system, this.getTestActor(), (Option<String>)Option.empty());
                        resourceManager = TestingUtils.createResourceManager(system, fakeJobManager.actor(), config);
                        this.expectMsgClass(RegisterResourceManager.class);
                        resourceManager.tell((Object)new RegisterResourceManagerSuccessful(fakeJobManager.actor(), Collections.emptyList()), fakeJobManager);
                        ResourceID resourceID1 = ResourceID.generate();
                        ResourceID resourceID2 = ResourceID.generate();
                        resourceManager.tell((Object)new NotifyResourceStarted(resourceID1), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new NotifyResourceStarted(resourceID2), fakeJobManager);
                        this.expectMsgClass(Acknowledge.class);
                        resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), fakeJobManager);
                        TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                        Assert.assertEquals((long)2L, (long)reply.resources.size());
                        Assert.assertTrue((boolean)reply.resources.contains(resourceID1));
                        Assert.assertTrue((boolean)reply.resources.contains(resourceID2));
                        resourceManager.tell((Object)new TestingResourceManager.FailResource(resourceID1), fakeJobManager);
                        resourceManager.tell((Object)new TestingResourceManager.FailResource(resourceID2), fakeJobManager);
                        ResourceRemoved answer = (ResourceRemoved)this.expectMsgClass(ResourceRemoved.class);
                        ResourceRemoved answer2 = (ResourceRemoved)this.expectMsgClass(ResourceRemoved.class);
                        Assert.assertEquals((Object)resourceID1, (Object)answer.resourceId());
                        Assert.assertEquals((Object)resourceID2, (Object)answer2.resourceId());
                    }
                };
            }
        };
    }

    static {
        config = new Configuration();
    }
}

