/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import com.typesafe.config.Config;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.messages.StopCluster;
import org.apache.flink.runtime.clusterframework.messages.StopClusterSuccessful;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.messages.Messages;
import org.apache.flink.runtime.testingUtils.TestingMessages;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.TestingResourceManager;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import scala.Option;

public class ClusterShutdownITCase
extends TestLogger {
    private static ActorSystem system;
    private static Configuration config;

    @BeforeClass
    public static void setup() {
        system = AkkaUtils.createActorSystem((Config)AkkaUtils.getDefaultAkkaConfig());
    }

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
    }

    @Test
    public void testClusterShutdownWithoutResourceManager() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(1.duration((String)"30 seconds")){

                    protected void run() {
                        ActorGateway me = TestingUtils.createForwardingActor(system, this.getTestActor(), (Option<String>)Option.empty());
                        ActorGateway jobManager = TestingUtils.createJobManager(system, config, "jobmanager1");
                        jobManager.tell(TestingMessages.getNotifyOfComponentShutdown(), me);
                        ActorGateway taskManager = TestingUtils.createTaskManager(system, jobManager, config, true, true);
                        taskManager.tell(TestingMessages.getNotifyOfComponentShutdown(), me);
                        jobManager.tell((Object)new StopCluster(ApplicationStatus.SUCCEEDED, "Shutting down."), me);
                        this.expectMsgAllOf(new Object[]{new TestingMessages.ComponentShutdown(taskManager.actor()), new TestingMessages.ComponentShutdown(jobManager.actor()), StopClusterSuccessful.getInstance()});
                    }
                };
            }
        };
    }

    @Test
    public void testClusterShutdownWithResourceManager() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(2.duration((String)"30 seconds")){

                    protected void run() {
                        ActorGateway me = TestingUtils.createForwardingActor(system, this.getTestActor(), (Option<String>)Option.empty());
                        ActorGateway jobManager = TestingUtils.createJobManager(system, config, "jobmanager2");
                        jobManager.tell(TestingMessages.getNotifyOfComponentShutdown(), me);
                        ActorGateway taskManager = TestingUtils.createTaskManager(system, jobManager, config, true, true);
                        taskManager.tell(TestingMessages.getNotifyOfComponentShutdown(), me);
                        ActorGateway resourceManager = TestingUtils.createResourceManager(system, jobManager.actor(), config);
                        resourceManager.tell(TestingMessages.getNotifyOfComponentShutdown(), me);
                        resourceManager.tell((Object)new TestingResourceManager.NotifyWhenResourceManagerConnected(), me);
                        this.expectMsgEquals(Messages.getAcknowledge());
                        jobManager.tell((Object)new StopCluster(ApplicationStatus.SUCCEEDED, "Shutting down."), me);
                        this.expectMsgAllOf(new Object[]{new TestingMessages.ComponentShutdown(taskManager.actor()), new TestingMessages.ComponentShutdown(jobManager.actor()), new TestingMessages.ComponentShutdown(resourceManager.actor()), StopClusterSuccessful.getInstance()});
                    }
                };
            }
        };
    }

    static {
        config = new Configuration();
    }
}

