/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;

public class MockInputSplitProvider
implements InputSplitProvider {
    private volatile InputSplit[] inputSplits;
    private int nextSplit = 0;

    public void addInputSplits(String path, int noSplits) {
        String localPath;
        InputSplit[] tmp = new InputSplit[noSplits];
        String[] hosts = new String[]{"localhost"};
        try {
            localPath = new URI(path).getPath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Path URI can not be transformed to local path.");
        }
        File inFile = new File(localPath);
        long splitLength = inFile.length() / (long)noSplits;
        long pos = 0L;
        for (int i = 0; i < noSplits - 1; ++i) {
            tmp[i] = new FileInputSplit(i, new Path(path), pos, splitLength, hosts);
            pos += splitLength;
        }
        tmp[noSplits - 1] = new FileInputSplit(noSplits - 1, new Path(path), pos, inFile.length() - pos, hosts);
        this.inputSplits = tmp;
    }

    public InputSplit getNextInputSplit() {
        if (this.nextSplit < this.inputSplits.length) {
            return this.inputSplits[this.nextSplit++];
        }
        return null;
    }
}

