/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.resettable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.resettable.NonReusingBlockResettableIterator;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.testutils.recordutils.RecordSerializer;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NonReusingBlockResettableIteratorTest {
    private static final int MEMORY_CAPACITY = 393216;
    private static final int NUM_VALUES = 20000;
    private MemoryManager memman;
    private Iterator<Record> reader;
    private List<Record> objects;
    private final TypeSerializer<Record> serializer = RecordSerializer.get();

    @Before
    public void startup() {
        this.memman = new MemoryManager(393216L, 1);
        this.objects = new ArrayList<Record>(20000);
        for (int i = 0; i < 20000; ++i) {
            this.objects.add(new Record((Value)new IntValue(i)));
        }
        this.reader = this.objects.iterator();
    }

    @After
    public void shutdown() {
        this.objects = null;
        if (!this.memman.verifyEmpty()) {
            Assert.fail((String)"A memory leak has occurred: Not all memory was properly returned to the memory manager.");
        }
        this.memman.shutdown();
        this.memman = null;
    }

    @Test
    public void testSerialBlockResettableIterator() throws Exception {
        DummyInvokable memOwner = new DummyInvokable();
        NonReusingBlockResettableIterator iterator = new NonReusingBlockResettableIterator(this.memman, this.reader, this.serializer, 1, (AbstractInvokable)memOwner);
        iterator.open();
        int lower = 0;
        int upper = 0;
        do {
            upper = lower = upper;
            while (iterator.hasNext()) {
                Record target = (Record)iterator.next();
                int val = ((IntValue)target.getField(0, IntValue.class)).getValue();
                Assert.assertEquals((long)upper++, (long)val);
            }
            for (int i = 0; i < 5; ++i) {
                iterator.reset();
                int count = 0;
                while (iterator.hasNext()) {
                    Record target = (Record)iterator.next();
                    int val = ((IntValue)target.getField(0, IntValue.class)).getValue();
                    Assert.assertEquals((long)(lower + count++), (long)val);
                }
                Assert.assertEquals((long)(upper - lower), (long)count);
            }
        } while (iterator.nextBlock());
        Assert.assertEquals((long)20000L, (long)upper);
        iterator.close();
    }

    @Test
    public void testDoubleBufferedBlockResettableIterator() throws Exception {
        DummyInvokable memOwner = new DummyInvokable();
        NonReusingBlockResettableIterator iterator = new NonReusingBlockResettableIterator(this.memman, this.reader, this.serializer, 2, (AbstractInvokable)memOwner);
        iterator.open();
        int lower = 0;
        int upper = 0;
        do {
            upper = lower = upper;
            while (iterator.hasNext()) {
                Record target = (Record)iterator.next();
                int val = ((IntValue)target.getField(0, IntValue.class)).getValue();
                Assert.assertEquals((long)upper++, (long)val);
            }
            for (int i = 0; i < 5; ++i) {
                iterator.reset();
                int count = 0;
                while (iterator.hasNext()) {
                    Record target = (Record)iterator.next();
                    int val = ((IntValue)target.getField(0, IntValue.class)).getValue();
                    Assert.assertEquals((long)(lower + count++), (long)val);
                }
                Assert.assertEquals((long)(upper - lower), (long)count);
            }
        } while (iterator.nextBlock());
        Assert.assertEquals((long)20000L, (long)upper);
        iterator.close();
    }

    @Test
    public void testTwelveFoldBufferedBlockResettableIterator() throws Exception {
        DummyInvokable memOwner = new DummyInvokable();
        NonReusingBlockResettableIterator iterator = new NonReusingBlockResettableIterator(this.memman, this.reader, this.serializer, 12, (AbstractInvokable)memOwner);
        iterator.open();
        int lower = 0;
        int upper = 0;
        do {
            upper = lower = upper;
            while (iterator.hasNext()) {
                Record target = (Record)iterator.next();
                int val = ((IntValue)target.getField(0, IntValue.class)).getValue();
                Assert.assertEquals((long)upper++, (long)val);
            }
            for (int i = 0; i < 5; ++i) {
                iterator.reset();
                int count = 0;
                while (iterator.hasNext()) {
                    Record target = (Record)iterator.next();
                    int val = ((IntValue)target.getField(0, IntValue.class)).getValue();
                    Assert.assertEquals((long)(lower + count++), (long)val);
                }
                Assert.assertEquals((long)(upper - lower), (long)count);
            }
        } while (iterator.nextBlock());
        Assert.assertEquals((long)20000L, (long)upper);
        iterator.close();
    }
}

