/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.apache.flink.runtime.net.ConnectionUtils;
import org.apache.flink.util.OperatingSystem;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionUtilsTest {
    @Test
    public void testReturnLocalHostAddressUsingHeuristics() {
        try (ServerSocket blocker = new ServerSocket(0, 1, InetAddress.getLocalHost());){
            InetSocketAddress unreachable = new InetSocketAddress("localhost", blocker.getLocalPort());
            long start = System.currentTimeMillis();
            InetAddress add = ConnectionUtils.findConnectingAddress((InetSocketAddress)unreachable, (long)2000L, (long)400L);
            Assert.assertTrue((System.currentTimeMillis() - start < (long)(OperatingSystem.isWindows() ? 30000 : 8000) ? 1 : 0) != 0);
            Assert.assertNotNull((Object)add);
            Assert.assertEquals((Object)InetAddress.getLocalHost(), (Object)add);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

