/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.scope.TaskManagerJobScopeFormat;
import org.apache.flink.runtime.metrics.scope.TaskManagerScopeFormat;
import org.apache.flink.runtime.metrics.scope.TaskScopeFormat;
import org.apache.flink.util.AbstractID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskMetricGroupTest {
    private CountingMetricRegistry registry;

    @Before
    public void createRegistry() {
        this.registry = new CountingMetricRegistry(new Configuration());
    }

    @After
    public void shutdownRegistry() {
        this.registry.shutdown();
        this.registry = null;
    }

    @Test
    public void testGenerateScopeDefault() {
        AbstractID vertexId = new AbstractID();
        AbstractID executionId = new AbstractID();
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)this.registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, tmGroup, new JobID(), "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup((MetricRegistry)this.registry, jmGroup, vertexId, executionId, "aTaskName", 13, 2);
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", "aTaskName", "13"}, (Object[])taskGroup.getScopeComponents());
        Assert.assertEquals((Object)"theHostName.taskmanager.test-tm-id.myJobName.aTaskName.13.name", (Object)taskGroup.getMetricIdentifier("name"));
        this.registry.shutdown();
    }

    @Test
    public void testGenerateScopeCustom() {
        TaskManagerScopeFormat tmFormat = new TaskManagerScopeFormat("abc");
        TaskManagerJobScopeFormat jmFormat = new TaskManagerJobScopeFormat("def", tmFormat);
        TaskScopeFormat taskFormat = new TaskScopeFormat("<tm_id>.<job_id>.<task_id>.<task_attempt_id>", jmFormat);
        JobID jid = new JobID();
        AbstractID vertexId = new AbstractID();
        AbstractID executionId = new AbstractID();
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)this.registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, tmGroup, jid, "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup((MetricRegistry)this.registry, jmGroup, taskFormat, vertexId, executionId, "aTaskName", 13, 2);
        Assert.assertArrayEquals((Object[])new String[]{"test-tm-id", jid.toString(), vertexId.toString(), executionId.toString()}, (Object[])taskGroup.getScopeComponents());
        Assert.assertEquals((Object)String.format("test-tm-id.%s.%s.%s.name", jid, vertexId, executionId), (Object)taskGroup.getMetricIdentifier("name"));
        this.registry.shutdown();
    }

    @Test
    public void testGenerateScopeWilcard() {
        TaskManagerScopeFormat tmFormat = new TaskManagerScopeFormat(ScopeFormat.DEFAULT_SCOPE_TASKMANAGER_GROUP);
        TaskManagerJobScopeFormat jmFormat = new TaskManagerJobScopeFormat(ScopeFormat.DEFAULT_SCOPE_TASKMANAGER_JOB_GROUP, tmFormat);
        TaskScopeFormat format = new TaskScopeFormat("*.<task_attempt_id>.<subtask_index>", jmFormat);
        AbstractID executionId = new AbstractID();
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)this.registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, tmGroup, new JobID(), "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup((MetricRegistry)this.registry, jmGroup, format, new AbstractID(), executionId, "aTaskName", 13, 1);
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", executionId.toString(), "13"}, (Object[])taskGroup.getScopeComponents());
        Assert.assertEquals((Object)("theHostName.taskmanager.test-tm-id.myJobName." + executionId + ".13.name"), (Object)taskGroup.getMetricIdentifier("name"));
        this.registry.shutdown();
    }

    @Test
    public void testTaskMetricGroupCleanup() {
        TaskManagerMetricGroup taskManagerMetricGroup = new TaskManagerMetricGroup((MetricRegistry)this.registry, "localhost", "0");
        TaskManagerJobMetricGroup taskManagerJobMetricGroup = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, taskManagerMetricGroup, new JobID(), "job");
        TaskMetricGroup taskMetricGroup = new TaskMetricGroup((MetricRegistry)this.registry, taskManagerJobMetricGroup, new AbstractID(), new AbstractID(), "task", 0, 0);
        Assert.assertTrue((this.registry.getNumberRegisteredMetrics() > 0 ? 1 : 0) != 0);
        taskMetricGroup.close();
        Assert.assertEquals((long)0L, (long)this.registry.getNumberRegisteredMetrics());
    }

    private static class CountingMetricRegistry
    extends MetricRegistry {
        private int counter = 0;

        CountingMetricRegistry(Configuration config) {
            super(config);
        }

        public void register(Metric metric, String metricName, MetricGroup group) {
            super.register(metric, metricName, group);
            ++this.counter;
        }

        public void unregister(Metric metric, String metricName, MetricGroup group) {
            super.unregister(metric, metricName, group);
            --this.counter;
        }

        int getNumberRegisteredMetrics() {
            return this.counter;
        }
    }
}

