/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.TaskManagerScopeFormat;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;

public class TaskManagerGroupTest {
    @Test
    public void addAndRemoveJobs() throws IOException {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        TaskManagerMetricGroup group = new TaskManagerMetricGroup(registry, "localhost", new AbstractID().toString());
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobVertexID vertex11 = new JobVertexID();
        JobVertexID vertex12 = new JobVertexID();
        JobVertexID vertex13 = new JobVertexID();
        JobVertexID vertex21 = new JobVertexID();
        ExecutionAttemptID execution11 = new ExecutionAttemptID();
        ExecutionAttemptID execution12 = new ExecutionAttemptID();
        ExecutionAttemptID execution13 = new ExecutionAttemptID();
        ExecutionAttemptID execution21 = new ExecutionAttemptID();
        TaskDeploymentDescriptor tdd1 = new TaskDeploymentDescriptor(jid1, "testjob", vertex11, execution11, new SerializedValue((Object)new ExecutionConfig()), "test", 17, 18, 0, new Configuration(), new Configuration(), "", new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), 0);
        TaskDeploymentDescriptor tdd2 = new TaskDeploymentDescriptor(jid1, "testjob", vertex12, execution12, new SerializedValue((Object)new ExecutionConfig()), "test", 13, 18, 1, new Configuration(), new Configuration(), "", new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), 0);
        TaskDeploymentDescriptor tdd3 = new TaskDeploymentDescriptor(jid2, "anotherJob", vertex21, execution21, new SerializedValue((Object)new ExecutionConfig()), "test", 7, 18, 2, new Configuration(), new Configuration(), "", new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), 0);
        TaskDeploymentDescriptor tdd4 = new TaskDeploymentDescriptor(jid1, "testjob", vertex13, execution13, new SerializedValue((Object)new ExecutionConfig()), "test", 0, 18, 0, new Configuration(), new Configuration(), "", new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), 0);
        TaskMetricGroup tmGroup11 = group.addTaskForJob(tdd1);
        TaskMetricGroup tmGroup12 = group.addTaskForJob(tdd2);
        TaskMetricGroup tmGroup21 = group.addTaskForJob(tdd3);
        Assert.assertEquals((long)2L, (long)group.numRegisteredJobMetricGroups());
        Assert.assertFalse((boolean)tmGroup11.parent().isClosed());
        Assert.assertFalse((boolean)tmGroup12.parent().isClosed());
        Assert.assertFalse((boolean)tmGroup21.parent().isClosed());
        tmGroup11.close();
        tmGroup21.close();
        Assert.assertTrue((boolean)tmGroup11.isClosed());
        Assert.assertTrue((boolean)tmGroup21.isClosed());
        Assert.assertFalse((boolean)tmGroup11.parent().isClosed());
        Assert.assertFalse((boolean)tmGroup12.parent().isClosed());
        Assert.assertTrue((boolean)tmGroup21.parent().isClosed());
        Assert.assertEquals((long)1L, (long)group.numRegisteredJobMetricGroups());
        TaskMetricGroup tmGroup13 = group.addTaskForJob(tdd4);
        tmGroup12.close();
        tmGroup13.close();
        Assert.assertTrue((boolean)tmGroup11.parent().isClosed());
        Assert.assertTrue((boolean)tmGroup12.parent().isClosed());
        Assert.assertTrue((boolean)tmGroup13.parent().isClosed());
        Assert.assertEquals((long)0L, (long)group.numRegisteredJobMetricGroups());
        registry.shutdown();
    }

    @Test
    public void testCloseClosesAll() throws IOException {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        TaskManagerMetricGroup group = new TaskManagerMetricGroup(registry, "localhost", new AbstractID().toString());
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobVertexID vertex11 = new JobVertexID();
        JobVertexID vertex12 = new JobVertexID();
        JobVertexID vertex21 = new JobVertexID();
        ExecutionAttemptID execution11 = new ExecutionAttemptID();
        ExecutionAttemptID execution12 = new ExecutionAttemptID();
        ExecutionAttemptID execution21 = new ExecutionAttemptID();
        TaskDeploymentDescriptor tdd1 = new TaskDeploymentDescriptor(jid1, "testjob", vertex11, execution11, new SerializedValue((Object)new ExecutionConfig()), "test", 17, 18, 0, new Configuration(), new Configuration(), "", new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), 0);
        TaskDeploymentDescriptor tdd2 = new TaskDeploymentDescriptor(jid1, "testjob", vertex12, execution12, new SerializedValue((Object)new ExecutionConfig()), "test", 13, 18, 1, new Configuration(), new Configuration(), "", new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), 0);
        TaskDeploymentDescriptor tdd3 = new TaskDeploymentDescriptor(jid2, "anotherJob", vertex21, execution21, new SerializedValue((Object)new ExecutionConfig()), "test", 7, 18, 1, new Configuration(), new Configuration(), "", new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), 0);
        TaskMetricGroup tmGroup11 = group.addTaskForJob(tdd1);
        TaskMetricGroup tmGroup12 = group.addTaskForJob(tdd2);
        TaskMetricGroup tmGroup21 = group.addTaskForJob(tdd3);
        group.close();
        Assert.assertTrue((boolean)tmGroup11.isClosed());
        Assert.assertTrue((boolean)tmGroup12.isClosed());
        Assert.assertTrue((boolean)tmGroup21.isClosed());
        registry.shutdown();
    }

    @Test
    public void testGenerateScopeDefault() {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        TaskManagerMetricGroup group = new TaskManagerMetricGroup(registry, "localhost", "id");
        Assert.assertArrayEquals((Object[])new String[]{"localhost", "taskmanager", "id"}, (Object[])group.getScopeComponents());
        Assert.assertEquals((Object)"localhost.taskmanager.id.name", (Object)group.getMetricIdentifier("name"));
        registry.shutdown();
    }

    @Test
    public void testGenerateScopeCustom() {
        MetricRegistry registry = new MetricRegistry(new Configuration());
        TaskManagerScopeFormat format = new TaskManagerScopeFormat("constant.<host>.foo.<host>");
        TaskManagerMetricGroup group = new TaskManagerMetricGroup(registry, format, "host", "id");
        Assert.assertArrayEquals((Object[])new String[]{"constant", "host", "foo", "host"}, (Object[])group.getScopeComponents());
        Assert.assertEquals((Object)"constant.host.foo.host.name", (Object)group.getMetricIdentifier("name"));
        registry.shutdown();
    }
}

