/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.reporter.Scheduled;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class MetricRegistryTest
extends TestLogger {
    @Test
    public void testReporterInstantiation() {
        Configuration config = new Configuration();
        config.setString("metrics.reporters", "test");
        config.setString("metrics.reporter.test.class", TestReporter1.class.getName());
        MetricRegistry metricRegistry = new MetricRegistry(config);
        Assert.assertTrue((metricRegistry.getReporters().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestReporter1.wasOpened);
    }

    @Test
    public void testMultipleReporterInstantiation() {
        Configuration config = new Configuration();
        config.setString("metrics.reporters", "test1, test2,test3");
        config.setString("metrics.reporter.test1.class", TestReporter11.class.getName());
        config.setString("metrics.reporter.test2.class", TestReporter12.class.getName());
        config.setString("metrics.reporter.test3.class", TestReporter13.class.getName());
        MetricRegistry metricRegistry = new MetricRegistry(config);
        Assert.assertTrue((metricRegistry.getReporters().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestReporter11.wasOpened);
        Assert.assertTrue((boolean)TestReporter12.wasOpened);
        Assert.assertTrue((boolean)TestReporter13.wasOpened);
    }

    @Test
    public void testReporterArgumentForwarding() {
        Configuration config = new Configuration();
        config.setString("metrics.reporters", "test");
        config.setString("metrics.reporter.test.class", TestReporter2.class.getName());
        config.setString("metrics.reporter.test.arg1", "hello");
        config.setString("metrics.reporter.test.arg2", "world");
        new MetricRegistry(config);
    }

    @Test
    public void testReporterScheduling() throws InterruptedException {
        Configuration config = new Configuration();
        config.setString("metrics.reporters", "test");
        config.setString("metrics.reporter.test.class", TestReporter3.class.getName());
        config.setString("metrics.reporter.test.arg1", "hello");
        config.setString("metrics.reporter.test.interval", "50 MILLISECONDS");
        new MetricRegistry(config);
        long start = System.currentTimeMillis();
        for (int x = 0; x < 10; ++x) {
            Thread.sleep(100L);
            int reportCount = TestReporter3.reportCount;
            long curT = System.currentTimeMillis();
            long maxAllowedReports = (curT - start) / 50L + 2L;
            Assert.assertTrue((String)"Too many report were triggered.", (maxAllowedReports >= (long)reportCount ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"No report was triggered.", (TestReporter3.reportCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReporterNotifications() {
        Configuration config = new Configuration();
        config.setString("metrics.reporters", "test1,test2");
        config.setString("metrics.reporter.test1.class", TestReporter6.class.getName());
        config.setString("metrics.reporter.test2.class", TestReporter7.class.getName());
        MetricRegistry registry = new MetricRegistry(config);
        TaskManagerMetricGroup root = new TaskManagerMetricGroup(registry, "host", "id");
        root.counter("rootCounter");
        root.close();
        Assert.assertTrue((boolean)TestReporter6.addCalled);
        Assert.assertTrue((boolean)TestReporter6.removeCalled);
        Assert.assertTrue((boolean)TestReporter7.addCalled);
        Assert.assertTrue((boolean)TestReporter7.removeCalled);
    }

    @Test
    public void testScopeConfig() {
        Configuration config = new Configuration();
        config.setString("metrics.scope.tm", "A");
        config.setString("metrics.scope.tm.job", "B");
        config.setString("metrics.scope.task", "C");
        config.setString("metrics.scope.operator", "D");
        ScopeFormats scopeConfig = MetricRegistry.createScopeConfig((Configuration)config);
        Assert.assertEquals((Object)"A", (Object)scopeConfig.getTaskManagerFormat().format());
        Assert.assertEquals((Object)"B", (Object)scopeConfig.getTaskManagerJobFormat().format());
        Assert.assertEquals((Object)"C", (Object)scopeConfig.getTaskFormat().format());
        Assert.assertEquals((Object)"D", (Object)scopeConfig.getOperatorFormat().format());
    }

    @Test
    public void testConfigurableDelimiter() {
        Configuration config = new Configuration();
        config.setString("metrics.scope.delimiter", "_");
        config.setString("metrics.scope.tm", "A.B.C.D.E");
        MetricRegistry registry = new MetricRegistry(config);
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup(registry, "host", "id");
        Assert.assertEquals((Object)"A_B_C_D_E_name", (Object)tmGroup.getMetricIdentifier("name"));
        registry.shutdown();
    }

    protected static class TestReporter7
    extends TestReporter {
        public static boolean addCalled = false;
        public static boolean removeCalled = false;

        protected TestReporter7() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            addCalled = true;
            Assert.assertTrue((boolean)(metric instanceof Counter));
            Assert.assertEquals((Object)"rootCounter", (Object)metricName);
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            removeCalled = true;
            Assert.assertTrue((boolean)(metric instanceof Counter));
            Assert.assertEquals((Object)"rootCounter", (Object)metricName);
        }
    }

    protected static class TestReporter6
    extends TestReporter {
        public static boolean addCalled = false;
        public static boolean removeCalled = false;

        protected TestReporter6() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            addCalled = true;
            Assert.assertTrue((boolean)(metric instanceof Counter));
            Assert.assertEquals((Object)"rootCounter", (Object)metricName);
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            removeCalled = true;
            Assert.assertTrue((boolean)(metric instanceof Counter));
            Assert.assertEquals((Object)"rootCounter", (Object)metricName);
        }
    }

    protected static class TestReporter3
    extends TestReporter
    implements Scheduled {
        public static int reportCount = 0;

        protected TestReporter3() {
        }

        public void report() {
            ++reportCount;
        }
    }

    protected static class TestReporter2
    extends TestReporter {
        protected TestReporter2() {
        }

        @Override
        public void open(MetricConfig config) {
            Assert.assertEquals((Object)"hello", (Object)config.getString("arg1", null));
            Assert.assertEquals((Object)"world", (Object)config.getString("arg2", null));
        }
    }

    protected static class TestReporter13
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter13() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    protected static class TestReporter12
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter12() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    protected static class TestReporter11
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter11() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    protected static class TestReporter1
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter1() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }
}

