/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingListener
implements LeaderRetrievalListener {
    private static Logger LOG = LoggerFactory.getLogger(TestingListener.class);
    private String address;
    private String oldAddress;
    private UUID leaderSessionID;
    private Exception exception;
    private Object lock = new Object();

    public String getAddress() {
        return this.address;
    }

    public UUID getLeaderSessionID() {
        return this.leaderSessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String waitForNewLeader(long timeout) throws Exception {
        long curTimeout;
        long start = System.currentTimeMillis();
        while (this.exception == null && (this.address == null || this.address.equals(this.oldAddress)) && (curTimeout = timeout - System.currentTimeMillis() + start) > 0L) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(curTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.address == null || this.address.equals(this.oldAddress)) {
            throw new TimeoutException("Listener was not notified about a leader within " + timeout + "ms");
        }
        this.oldAddress = this.address;
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyLeaderAddress(String leaderAddress, UUID leaderSessionID) {
        Object object = this.lock;
        synchronized (object) {
            LOG.debug("Notified about new leader address {} with session ID {}.", (Object)leaderAddress, (Object)leaderSessionID);
            this.address = leaderAddress;
            this.leaderSessionID = leaderSessionID;
            this.lock.notifyAll();
        }
    }

    public void handleError(Exception exception) {
        this.exception = exception;
    }
}

