/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import akka.actor.ActorRef;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingLeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.testingUtils.TestingCluster;
import scala.Option;
import scala.collection.Seq;

public class LeaderElectionRetrievalTestingCluster
extends TestingCluster {
    private final Configuration userConfiguration;
    private final boolean useSingleActorSystem;
    public List<TestingLeaderElectionService> leaderElectionServices;
    public List<TestingLeaderRetrievalService> leaderRetrievalServices;
    private int leaderIndex = -1;

    public LeaderElectionRetrievalTestingCluster(Configuration userConfiguration, boolean singleActorSystem, boolean synchronousDispatcher) {
        super(userConfiguration, singleActorSystem, synchronousDispatcher);
        this.userConfiguration = userConfiguration;
        this.useSingleActorSystem = singleActorSystem;
        this.leaderElectionServices = new ArrayList<TestingLeaderElectionService>();
        this.leaderRetrievalServices = new ArrayList<TestingLeaderRetrievalService>();
    }

    public Configuration userConfiguration() {
        return this.userConfiguration;
    }

    public boolean useSingleActorSystem() {
        return this.useSingleActorSystem;
    }

    @Override
    public Option<LeaderElectionService> createLeaderElectionService() {
        this.leaderElectionServices.add(new TestingLeaderElectionService());
        LeaderElectionService result = this.leaderElectionServices.get(this.leaderElectionServices.size() - 1);
        return Option.apply((Object)result);
    }

    public LeaderRetrievalService createLeaderRetrievalService() {
        this.leaderRetrievalServices.add(new TestingLeaderRetrievalService());
        return this.leaderRetrievalServices.get(this.leaderRetrievalServices.size() - 1);
    }

    public int getNumberOfJobManagers() {
        return this.configuration().getInteger("local.number-jobmanager", 1);
    }

    public void grantLeadership(int index, UUID leaderSessionID) {
        if (this.leaderIndex >= 0) {
            this.leaderElectionServices.get(this.leaderIndex).notLeader();
        }
        this.leaderElectionServices.get(index).isLeader(leaderSessionID);
        this.leaderIndex = index;
    }

    public void notifyRetrievalListeners(int index, UUID leaderSessionID) {
        String address = ((ActorRef)((Seq)this.jobManagerActors().get()).apply(index)).path().toString();
        for (TestingLeaderRetrievalService service : this.leaderRetrievalServices) {
            service.notifyListener(address, leaderSessionID);
        }
    }

    public void revokeLeadership() {
        if (this.leaderIndex >= 0) {
            this.leaderElectionServices.get(this.leaderIndex).notLeader();
            this.leaderIndex = -1;
        }
    }
}

