/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.DummyActorGateway;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.mockito.Mockito;

public class SchedulerTestUtils {
    private static final AtomicInteger port = new AtomicInteger(10000);

    public static Instance getRandomInstance(int numSlots) {
        InetAddress address;
        if (numSlots <= 0) {
            throw new IllegalArgumentException();
        }
        try {
            address = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Test could not create IP address for localhost loopback.");
        }
        int dataPort = port.getAndIncrement();
        InstanceConnectionInfo ci = new InstanceConnectionInfo(address, dataPort);
        long GB = 0x40000000L;
        HardwareDescription resources = new HardwareDescription(4, 0x100000000L, 0xC0000000L, 0x80000000L);
        return new Instance((ActorGateway)DummyActorGateway.INSTANCE, ci, ResourceID.generate(), new InstanceID(), resources, numSlots);
    }

    public static Execution getDummyTask() {
        ExecutionVertex vertex = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        Mockito.when((Object)vertex.getJobId()).thenReturn((Object)new JobID());
        Mockito.when((Object)vertex.toString()).thenReturn((Object)"TEST-VERTEX");
        Execution execution = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)execution.getVertex()).thenReturn((Object)vertex);
        return execution;
    }

    public static Execution getTestVertex(Iterable<Instance> preferredLocations) {
        ExecutionVertex vertex = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        Mockito.when((Object)vertex.getPreferredLocations()).thenReturn(preferredLocations);
        Mockito.when((Object)vertex.getJobId()).thenReturn((Object)new JobID());
        Mockito.when((Object)vertex.toString()).thenReturn((Object)"TEST-VERTEX");
        Execution execution = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)execution.getVertex()).thenReturn((Object)vertex);
        return execution;
    }

    public static Execution getTestVertex(JobVertexID jid, int taskIndex, int numTasks) {
        ExecutionVertex vertex = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        Mockito.when((Object)vertex.getPreferredLocations()).thenReturn(null);
        Mockito.when((Object)vertex.getJobId()).thenReturn((Object)new JobID());
        Mockito.when((Object)vertex.getJobvertexId()).thenReturn((Object)jid);
        Mockito.when((Object)vertex.getParallelSubtaskIndex()).thenReturn((Object)taskIndex);
        Mockito.when((Object)vertex.getTotalNumberOfParallelSubtasks()).thenReturn((Object)numTasks);
        Mockito.when((Object)vertex.toString()).thenReturn((Object)"TEST-VERTEX");
        Mockito.when((Object)vertex.getSimpleName()).thenReturn((Object)"TEST-VERTEX");
        Execution execution = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)execution.getVertex()).thenReturn((Object)vertex);
        return execution;
    }

    public static Execution getTestVertexWithLocation(JobVertexID jid, int taskIndex, int numTasks, Instance ... locations) {
        ExecutionVertex vertex = (ExecutionVertex)Mockito.mock(ExecutionVertex.class);
        Mockito.when((Object)vertex.getPreferredLocations()).thenReturn(Arrays.asList(locations));
        Mockito.when((Object)vertex.getJobId()).thenReturn((Object)new JobID());
        Mockito.when((Object)vertex.getJobvertexId()).thenReturn((Object)jid);
        Mockito.when((Object)vertex.getParallelSubtaskIndex()).thenReturn((Object)taskIndex);
        Mockito.when((Object)vertex.getTotalNumberOfParallelSubtasks()).thenReturn((Object)numTasks);
        Mockito.when((Object)vertex.toString()).thenReturn((Object)"TEST-VERTEX");
        Execution execution = (Execution)Mockito.mock(Execution.class);
        Mockito.when((Object)execution.getVertex()).thenReturn((Object)vertex);
        return execution;
    }

    public static boolean areAllDistinct(Object ... obj) {
        if (obj == null) {
            return true;
        }
        HashSet set = new HashSet();
        Collections.addAll(set, obj);
        return set.size() == obj.length;
    }

    public static boolean areSameSets(Collection<Object> set1, Collection<Object> set2) {
        if (set1 == null || set2 == null) {
            throw new IllegalArgumentException();
        }
        HashSet<Object> set = new HashSet<Object>(set1);
        for (Object o : set2) {
            if (set.remove(o)) continue;
            return false;
        }
        return set.isEmpty();
    }
}

