/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestUtils;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.AbstractID;
import org.junit.Assert;
import org.junit.Test;
import scala.concurrent.ExecutionContext;

public class SchedulerSlotSharingTest {
    @Test
    public void scheduleSingleVertexType() {
        try {
            JobVertexID jid1 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1});
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            Instance i1 = SchedulerTestUtils.getRandomInstance(2);
            Instance i2 = SchedulerTestUtils.getRandomInstance(2);
            scheduler.newInstanceAvailable(i1);
            scheduler.newInstanceAvailable(i2);
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 8), sharingGroup));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 8), sharingGroup));
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 8), sharingGroup));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 8), sharingGroup));
            Assert.assertNotNull((Object)s1);
            Assert.assertNotNull((Object)s2);
            Assert.assertNotNull((Object)s3);
            Assert.assertNotNull((Object)s4);
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1, s2, s3, s4));
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 4, 8), sharingGroup));
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (NoResourceAvailableException noResourceAvailableException) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            s3.releaseSlot();
            SimpleSlot s5 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 4, 8), sharingGroup));
            Assert.assertNotNull((Object)s5);
            s1.releaseSlot();
            s2.releaseSlot();
            s4.releaseSlot();
            SimpleSlot s6 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 5, 8), sharingGroup));
            SimpleSlot s7 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 6, 8), sharingGroup));
            SimpleSlot s8 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 7, 8), sharingGroup));
            Assert.assertNotNull((Object)s6);
            Assert.assertNotNull((Object)s7);
            Assert.assertNotNull((Object)s8);
            int c = 0;
            c += s5.getInstance() == i1 ? 1 : -1;
            c += s6.getInstance() == i1 ? 1 : -1;
            c += s7.getInstance() == i1 ? 1 : -1;
            Assert.assertEquals((long)0L, (long)(c += s8.getInstance() == i1 ? 1 : -1));
            s5.releaseSlot();
            s6.releaseSlot();
            s7.releaseSlot();
            s8.releaseSlot();
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)8L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void scheduleImmediatelyWithSharing() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 5), sharingGroup));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 5), sharingGroup));
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 5), sharingGroup));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 5), sharingGroup));
            Assert.assertNotNull((Object)s1);
            Assert.assertNotNull((Object)s2);
            Assert.assertNotNull((Object)s3);
            Assert.assertNotNull((Object)s4);
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1, s2, s3, s4));
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 4, 5), sharingGroup));
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (NoResourceAvailableException noResourceAvailableException) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            SimpleSlot s1_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 5), sharingGroup));
            SimpleSlot s2_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 5), sharingGroup));
            SimpleSlot s3_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 5), sharingGroup));
            SimpleSlot s4_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 5), sharingGroup));
            Assert.assertNotNull((Object)s1_2);
            Assert.assertNotNull((Object)s2_2);
            Assert.assertNotNull((Object)s3_2);
            Assert.assertNotNull((Object)s4_2);
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 4, 5), sharingGroup));
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (NoResourceAvailableException noResourceAvailableException) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            s1.releaseSlot();
            s4.releaseSlot();
            Assert.assertEquals((long)4L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)2L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid1));
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid2));
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 4, 5), sharingGroup));
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (NoResourceAvailableException e) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            SimpleSlot s5 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 4, 5), sharingGroup));
            Assert.assertNotNull((Object)s5);
            Assert.assertEquals((long)4L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)1L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid1));
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid2));
            s2_2.releaseSlot();
            SimpleSlot s5_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 4, 5), sharingGroup));
            Assert.assertNotNull((Object)s5_2);
            s2.releaseSlot();
            s3.releaseSlot();
            s5.releaseSlot();
            s1_2.releaseSlot();
            s3_2.releaseSlot();
            s4_2.releaseSlot();
            s5_2.releaseSlot();
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)10L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void scheduleImmediatelyWithIntermediateTotallyEmptySharingGroup() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 4), sharingGroup));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 4), sharingGroup));
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 4), sharingGroup));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 4), sharingGroup));
            Assert.assertEquals((long)4L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid1));
            Assert.assertEquals((long)4L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid2));
            s1.releaseSlot();
            s2.releaseSlot();
            s3.releaseSlot();
            s4.releaseSlot();
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid1));
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid2));
            SimpleSlot s1_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 4), sharingGroup));
            SimpleSlot s2_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 4), sharingGroup));
            SimpleSlot s3_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 4), sharingGroup));
            SimpleSlot s4_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 4), sharingGroup));
            Assert.assertEquals((long)4L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)4L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid1));
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid2));
            s1_2.releaseSlot();
            s2_2.releaseSlot();
            s3_2.releaseSlot();
            s4_2.releaseSlot();
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid1));
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid2));
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)8L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void scheduleImmediatelyWithTemprarilyEmptyVertexGroup() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2, jid3});
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            SimpleSlot s1_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 4), sharingGroup));
            SimpleSlot s2_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 4), sharingGroup));
            SimpleSlot s3_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 4), sharingGroup));
            SimpleSlot s4_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 4), sharingGroup));
            Assert.assertNotNull((Object)s1_1);
            Assert.assertNotNull((Object)s2_1);
            Assert.assertNotNull((Object)s3_1);
            Assert.assertNotNull((Object)s4_1);
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1_1, s2_1, s3_1, s4_1));
            SimpleSlot s1_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 7), sharingGroup));
            SimpleSlot s2_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 7), sharingGroup));
            SimpleSlot s3_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 7), sharingGroup));
            SimpleSlot s4_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 7), sharingGroup));
            Assert.assertNotNull((Object)s1_2);
            Assert.assertNotNull((Object)s2_2);
            Assert.assertNotNull((Object)s3_2);
            Assert.assertNotNull((Object)s4_2);
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1_2, s2_2, s3_2, s4_2));
            SimpleSlot s1_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 4), sharingGroup));
            SimpleSlot s2_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 1, 4), sharingGroup));
            SimpleSlot s3_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 2, 4), sharingGroup));
            SimpleSlot s4_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 3, 4), sharingGroup));
            Assert.assertNotNull((Object)s1_3);
            Assert.assertNotNull((Object)s2_3);
            Assert.assertNotNull((Object)s3_3);
            Assert.assertNotNull((Object)s4_3);
            Assert.assertTrue((boolean)SchedulerTestUtils.areAllDistinct(s1_3, s2_3, s3_3, s4_3));
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 4, 5), sharingGroup));
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (NoResourceAvailableException noResourceAvailableException) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            s1_2.releaseSlot();
            s2_2.releaseSlot();
            s3_2.releaseSlot();
            s4_2.releaseSlot();
            SimpleSlot s5_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 5, 7), sharingGroup));
            SimpleSlot s6_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 6, 7), sharingGroup));
            SimpleSlot s7_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 7, 7), sharingGroup));
            Assert.assertNotNull((Object)s5_2);
            Assert.assertNotNull((Object)s6_2);
            Assert.assertNotNull((Object)s7_2);
            s1_1.releaseSlot();
            s2_1.releaseSlot();
            s3_1.releaseSlot();
            s4_1.releaseSlot();
            s5_2.releaseSlot();
            s6_2.releaseSlot();
            s7_2.releaseSlot();
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
            s1_3.releaseSlot();
            s2_3.releaseSlot();
            s3_3.releaseSlot();
            s4_3.releaseSlot();
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)15L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void scheduleImmediatelyWithTemprarilyEmptyVertexGroup2() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            SimpleSlot s1_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 2), sharingGroup));
            SimpleSlot s2_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 2), sharingGroup));
            SimpleSlot s2_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 2), sharingGroup));
            Assert.assertNotNull((Object)s1_1);
            Assert.assertNotNull((Object)s2_1);
            Assert.assertNotNull((Object)s2_2);
            Assert.assertEquals((long)2L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)1L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid1));
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid2));
            s2_1.releaseSlot();
            s2_2.releaseSlot();
            SimpleSlot sx = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 1)));
            Assert.assertNotNull((Object)sx);
            Assert.assertEquals((long)1L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid1));
            Assert.assertEquals((long)1L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid2));
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void scheduleMixedSharingAndNonSharing() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jidA = new JobVertexID();
            JobVertexID jidB = new JobVertexID();
            JobVertexID jidC = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(3));
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            SimpleSlot sA1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidA, 0, 2)));
            SimpleSlot sA2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidA, 1, 2)));
            Assert.assertNotNull((Object)sA1);
            Assert.assertNotNull((Object)sA2);
            SimpleSlot s1_0 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 4), sharingGroup));
            SimpleSlot s1_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 4), sharingGroup));
            SimpleSlot s2_0 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 4), sharingGroup));
            SimpleSlot s2_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 4), sharingGroup));
            Assert.assertNotNull((Object)s1_0);
            Assert.assertNotNull((Object)s1_1);
            Assert.assertNotNull((Object)s2_0);
            Assert.assertNotNull((Object)s2_1);
            SimpleSlot sB1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidB, 1, 3)));
            Assert.assertNotNull((Object)sB1);
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 4), sharingGroup));
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (NoResourceAvailableException noResourceAvailableException) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 4), sharingGroup));
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (NoResourceAvailableException e) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidB, 0, 3)));
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (NoResourceAvailableException e) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidC, 0, 1)));
                Assert.fail((String)"Scheduler accepted too many tasks at the same time");
            }
            catch (NoResourceAvailableException e) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception.");
            }
            sA1.releaseSlot();
            SimpleSlot s1_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 4), sharingGroup));
            SimpleSlot s2_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 4), sharingGroup));
            Assert.assertNotNull((Object)s1_2);
            Assert.assertNotNull((Object)s2_2);
            s1_0.releaseSlot();
            s1_1.releaseSlot();
            s2_0.releaseSlot();
            Assert.assertEquals((long)1L, (long)scheduler.getNumberOfAvailableSlots());
            SimpleSlot sB0 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidB, 0, 3)));
            Assert.assertNotNull((Object)sB0);
            s2_1.releaseSlot();
            SimpleSlot sB2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidB, 2, 3)));
            Assert.assertNotNull((Object)sB2);
            sA2.releaseSlot();
            SimpleSlot s1_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 4), sharingGroup));
            SimpleSlot s2_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 4), sharingGroup));
            Assert.assertNotNull((Object)s1_3);
            Assert.assertNotNull((Object)s2_3);
            s1_2.releaseSlot();
            s2_2.releaseSlot();
            s1_3.releaseSlot();
            s2_3.releaseSlot();
            SimpleSlot sC0 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidC, 1, 2)));
            SimpleSlot sC1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jidC, 0, 2)));
            Assert.assertNotNull((Object)sC0);
            Assert.assertNotNull((Object)sC1);
            sB0.releaseSlot();
            sB1.releaseSlot();
            sB2.releaseSlot();
            sC0.releaseSlot();
            sC1.releaseSlot();
            Assert.assertEquals((long)5L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)15L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLocalizedAssignment1() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            Instance i1 = SchedulerTestUtils.getRandomInstance(2);
            Instance i2 = SchedulerTestUtils.getRandomInstance(2);
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(i1);
            scheduler.newInstanceAvailable(i2);
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 0, 2, i1), sharingGroup));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 1, 2, i2), sharingGroup));
            Assert.assertNotNull((Object)s1);
            Assert.assertNotNull((Object)s2);
            Assert.assertEquals((long)2L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)1L, (long)i1.getNumberOfAvailableSlots());
            Assert.assertEquals((long)1L, (long)i2.getNumberOfAvailableSlots());
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 0, 2, i1), sharingGroup));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 1, 2, i2), sharingGroup));
            Assert.assertNotNull((Object)s3);
            Assert.assertNotNull((Object)s4);
            Assert.assertEquals((long)2L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)1L, (long)i1.getNumberOfAvailableSlots());
            Assert.assertEquals((long)1L, (long)i2.getNumberOfAvailableSlots());
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLocalizedAssignment2() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            Instance i1 = SchedulerTestUtils.getRandomInstance(2);
            Instance i2 = SchedulerTestUtils.getRandomInstance(2);
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(i1);
            scheduler.newInstanceAvailable(i2);
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 0, 2, i1), sharingGroup));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 1, 2, i1), sharingGroup));
            Assert.assertNotNull((Object)s1);
            Assert.assertNotNull((Object)s2);
            Assert.assertEquals((long)2L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)i1.getNumberOfAvailableSlots());
            Assert.assertEquals((long)2L, (long)i2.getNumberOfAvailableSlots());
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 0, 2, i2), sharingGroup));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 1, 2, i2), sharingGroup));
            Assert.assertNotNull((Object)s3);
            Assert.assertNotNull((Object)s4);
            Assert.assertEquals((long)4L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)i1.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)i2.getNumberOfAvailableSlots());
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLocalizedAssignment3() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2});
            Instance i1 = SchedulerTestUtils.getRandomInstance(2);
            Instance i2 = SchedulerTestUtils.getRandomInstance(2);
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(i1);
            scheduler.newInstanceAvailable(i2);
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 0, 2, i1), sharingGroup));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 1, 2, i1), sharingGroup));
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 0, 4, i1), sharingGroup));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 1, 4, i1), sharingGroup));
            SimpleSlot s5 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 3, 4, i1), sharingGroup));
            SimpleSlot s6 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 4, 4, i1), sharingGroup));
            Assert.assertNotNull((Object)s1);
            Assert.assertNotNull((Object)s2);
            Assert.assertNotNull((Object)s3);
            Assert.assertNotNull((Object)s4);
            Assert.assertNotNull((Object)s5);
            Assert.assertNotNull((Object)s6);
            Assert.assertEquals((long)4L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)i1.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)i2.getNumberOfAvailableSlots());
            Assert.assertEquals((Object)i1, (Object)s1.getInstance());
            Assert.assertEquals((Object)i1, (Object)s2.getInstance());
            Assert.assertEquals((Object)i1, (Object)s3.getInstance());
            Assert.assertEquals((Object)i1, (Object)s4.getInstance());
            Assert.assertEquals((Object)i2, (Object)s5.getInstance());
            Assert.assertEquals((Object)i2, (Object)s6.getInstance());
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSequentialAllocateAndRelease() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            JobVertexID jid4 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2, jid3, jid4});
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(4));
            SimpleSlot slot_1_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 4), sharingGroup));
            SimpleSlot slot_1_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 4), sharingGroup));
            SimpleSlot slot_2_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 4), sharingGroup));
            SimpleSlot slot_2_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 4), sharingGroup));
            SimpleSlot slot_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 1), sharingGroup));
            SimpleSlot slot_1_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 4), sharingGroup));
            SimpleSlot slot_1_4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 4), sharingGroup));
            SimpleSlot slot_2_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 4), sharingGroup));
            SimpleSlot slot_2_4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 4), sharingGroup));
            slot_1_1.releaseSlot();
            slot_1_2.releaseSlot();
            slot_1_3.releaseSlot();
            slot_1_4.releaseSlot();
            slot_2_1.releaseSlot();
            slot_2_2.releaseSlot();
            slot_2_3.releaseSlot();
            slot_2_4.releaseSlot();
            SimpleSlot slot_4_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 0, 4), sharingGroup));
            SimpleSlot slot_4_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 1, 4), sharingGroup));
            SimpleSlot slot_4_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 2, 4), sharingGroup));
            SimpleSlot slot_4_4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 3, 4), sharingGroup));
            slot_3.releaseSlot();
            slot_4_1.releaseSlot();
            slot_4_2.releaseSlot();
            slot_4_3.releaseSlot();
            slot_4_4.releaseSlot();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentAllocateAndRelease() {
        final ExecutorService executor = Executors.newFixedThreadPool(20);
        try {
            for (int run = 0; run < 50; ++run) {
                final JobVertexID jid1 = new JobVertexID();
                final JobVertexID jid2 = new JobVertexID();
                final JobVertexID jid3 = new JobVertexID();
                final JobVertexID jid4 = new JobVertexID();
                final SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2, jid3, jid4});
                final Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.defaultExecutionContext());
                scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(4));
                final AtomicInteger enumerator1 = new AtomicInteger();
                final AtomicInteger enumerator2 = new AtomicInteger();
                final AtomicBoolean flag3 = new AtomicBoolean();
                final AtomicInteger enumerator4 = new AtomicInteger();
                final Random rnd = new Random();
                final AtomicBoolean failed = new AtomicBoolean(false);
                final AtomicInteger completed = new AtomicInteger();
                final Runnable deploy4 = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                SimpleSlot slot = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, enumerator4.getAndIncrement(), 4), sharingGroup));
                                CommonTestUtils.sleepUninterruptibly(rnd.nextInt(5));
                                slot.releaseSlot();
                                if (completed.incrementAndGet() != 13) break block5;
                                AtomicInteger atomicInteger = completed;
                                synchronized (atomicInteger) {
                                    completed.notifyAll();
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                failed.set(true);
                            }
                        }
                    }
                };
                final Runnable deploy3 = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                if (!flag3.compareAndSet(false, true)) break block5;
                                SimpleSlot slot = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 1), sharingGroup));
                                CommonTestUtils.sleepUninterruptibly(5L);
                                executor.execute(deploy4);
                                executor.execute(deploy4);
                                executor.execute(deploy4);
                                executor.execute(deploy4);
                                slot.releaseSlot();
                                if (completed.incrementAndGet() != 13) break block5;
                                AtomicInteger atomicInteger = completed;
                                synchronized (atomicInteger) {
                                    completed.notifyAll();
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                failed.set(true);
                            }
                        }
                    }
                };
                final Runnable deploy2 = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                SimpleSlot slot = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, enumerator2.getAndIncrement(), 4), sharingGroup));
                                CommonTestUtils.sleepUninterruptibly(rnd.nextInt(5));
                                executor.execute(deploy3);
                                CommonTestUtils.sleepUninterruptibly(rnd.nextInt(5));
                                slot.releaseSlot();
                                if (completed.incrementAndGet() != 13) break block5;
                                AtomicInteger atomicInteger = completed;
                                synchronized (atomicInteger) {
                                    completed.notifyAll();
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                failed.set(true);
                            }
                        }
                    }
                };
                final Runnable deploy1 = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                SimpleSlot slot = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, enumerator1.getAndIncrement(), 4), sharingGroup));
                                CommonTestUtils.sleepUninterruptibly(rnd.nextInt(5));
                                executor.execute(deploy2);
                                CommonTestUtils.sleepUninterruptibly(rnd.nextInt(5));
                                slot.releaseSlot();
                                if (completed.incrementAndGet() != 13) break block5;
                                AtomicInteger atomicInteger = completed;
                                synchronized (atomicInteger) {
                                    completed.notifyAll();
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                failed.set(true);
                            }
                        }
                    }
                };
                Runnable deploy0 = new Runnable(){

                    @Override
                    public void run() {
                        CommonTestUtils.sleepUninterruptibly(rnd.nextInt(10));
                        executor.execute(deploy1);
                    }
                };
                executor.execute(deploy0);
                executor.execute(deploy0);
                executor.execute(deploy0);
                executor.execute(deploy0);
                AtomicInteger atomicInteger = completed;
                synchronized (atomicInteger) {
                    while (!failed.get() && completed.get() < 13) {
                        completed.wait(1000L);
                    }
                }
                Assert.assertFalse((String)"Thread failed", (boolean)failed.get());
                while (scheduler.getNumberOfAvailableSlots() < 4) {
                    CommonTestUtils.sleepUninterruptibly(5L);
                }
                Assert.assertEquals((long)1L, (long)scheduler.getNumberOfAvailableInstances());
                Assert.assertEquals((long)1L, (long)scheduler.getNumberOfInstancesWithAvailableSlots());
                Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
                Assert.assertEquals((long)13L, (long)scheduler.getNumberOfUnconstrainedAssignments());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDopIncreases() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            JobVertexID jid4 = new JobVertexID();
            SlotSharingGroup sharingGroup = new SlotSharingGroup(new JobVertexID[]{jid1, jid2, jid3, jid4});
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(4));
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 1), sharingGroup));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 1), sharingGroup));
            Assert.assertTrue((s1.getParent() == s2.getParent() ? 1 : 0) != 0);
            Assert.assertEquals((long)3L, (long)scheduler.getNumberOfAvailableSlots());
            SimpleSlot s3_0 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 5), sharingGroup));
            SimpleSlot s3_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 1, 5), sharingGroup));
            SimpleSlot s4_0 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 0, 4), sharingGroup));
            SimpleSlot s4_1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 1, 4), sharingGroup));
            s1.releaseSlot();
            s2.releaseSlot();
            SimpleSlot s3_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 2, 5), sharingGroup));
            SimpleSlot s3_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 3, 5), sharingGroup));
            SimpleSlot s4_2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 2, 4), sharingGroup));
            SimpleSlot s4_3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 3, 4), sharingGroup));
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 4, 5), sharingGroup));
                Assert.fail((String)"should throw an exception");
            }
            catch (NoResourceAvailableException noResourceAvailableException) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
            s3_0.releaseSlot();
            s3_1.releaseSlot();
            s3_2.releaseSlot();
            s3_3.releaseSlot();
            s4_0.releaseSlot();
            s4_1.releaseSlot();
            s4_2.releaseSlot();
            s4_3.releaseSlot();
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

